/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.net.lenni0451.reflect.proxy;

import java.lang.reflect.Constructor;
import unilib.external.net.lenni0451.reflect.Constructors;
import unilib.external.net.lenni0451.reflect.Objects;
import unilib.external.net.lenni0451.reflect.exceptions.ConstructorNotFoundException;
import unilib.external.net.lenni0451.reflect.proxy.InvocationHandler;
import unilib.external.net.lenni0451.reflect.proxy.impl.Proxy;

public class ProxyClass {
    private final Class<?> proxyClass;
    private InvocationHandler invocationHandler;

    public ProxyClass(Class<?> proxyClass, InvocationHandler invocationHandler) {
        this.proxyClass = proxyClass;
        this.invocationHandler = invocationHandler;
    }

    public Class<?> getProxyClass() {
        return this.proxyClass;
    }

    public InvocationHandler getInvocationHandler() {
        return this.invocationHandler;
    }

    public void setInvocationHandler(InvocationHandler invocationHandler) {
        this.invocationHandler = invocationHandler;
    }

    public <T> T allocateInstance() {
        Object instance = Objects.allocate(this.proxyClass);
        ((Proxy)instance).setInvocationHandler(this.invocationHandler);
        return (T)instance;
    }

    public <T> T instantiate(Class<?>[] constructorParameters, Object[] constructorArguments) {
        Constructor<?> constructor = Constructors.getDeclaredConstructor(this.proxyClass, constructorParameters);
        if (constructor == null) {
            throw new ConstructorNotFoundException("Proxy", constructorParameters);
        }
        Object instance = Constructors.invoke(constructor, constructorArguments);
        ((Proxy)instance).setInvocationHandler(this.invocationHandler);
        return (T)instance;
    }
}

