/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.controls;

import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class CheckBoxControl
extends ExtendedButtonControl {
    private static final int DEFAULT_BORDER = 1;
    private static final int DEFAULT_BOX_WIDTH = 11;
    private static final int DEFAULT_MAX_TEXT_WIDTH = 167;
    private int boxWidth;
    private int borderWidth;
    private int maxTextWidth;
    private boolean is_Checked;

    public CheckBoxControl(int id, int xPos, int yPos, String displayString, boolean isChecked) {
        super(id, xPos, yPos, displayString);
        this.resetRenderStates();
        this.setIsChecked(isChecked);
    }

    public CheckBoxControl(int id, int xPos, int yPos, String displayString, boolean isChecked, Runnable onPushEvent) {
        this(id, xPos, yPos, displayString, isChecked);
        this.setOnClick(onPushEvent);
    }

    public CheckBoxControl(int id, int xPos, int yPos, String displayString, boolean isChecked, Runnable onPushEvent, Runnable onHoverEvent) {
        this(id, xPos, yPos, displayString, isChecked, onPushEvent);
        this.setOnHover(onHoverEvent);
    }

    public CheckBoxControl(int xPos, int yPos, String displayString, boolean isChecked) {
        this(ExtendedScreen.getNextIndex(), xPos, yPos, displayString, isChecked);
    }

    public CheckBoxControl(int xPos, int yPos, String displayString, boolean isChecked, Runnable onPushEvent) {
        this(xPos, yPos, displayString, isChecked);
        this.setOnClick(onPushEvent);
    }

    public CheckBoxControl(int xPos, int yPos, String displayString, boolean isChecked, Runnable onPushEvent, Runnable onHoverEvent) {
        this(xPos, yPos, displayString, isChecked, onPushEvent);
        this.setOnHover(onHoverEvent);
    }

    @Override
    public void m_87963_(@Nonnull GuiGraphics matrixStack, int mouseX, int mouseY, float partial) {
        Minecraft mc = ModUtils.getMinecraft();
        if (mc != null && this.isControlVisible()) {
            int color;
            this.setHoveringOver(this.isOverScreen() && RenderUtils.isMouseOver((double)mouseX, (double)mouseY, this));
            this.renderBg(matrixStack, mc, mouseX, mouseY);
            int n = color = !this.isControlEnabled() ? 0xA0A0A0 : 0xE0E0E0;
            if (this.isChecked()) {
                RenderUtils.renderCenteredString(matrixStack, mc.f_91062_, "x", this.getControlPosX() + this.getBoxWidth() / 2 + 1, this.getControlPosY() + 1, color);
            }
            int left = this.getControlPosX() + this.getBoxWidth() + 2;
            RenderUtils.renderScrollingString(matrixStack, mc, mc.f_91062_, this.getControlMessage(), left + RenderUtils.getStringWidth(mc.f_91062_, this.getControlMessage()) / 2, left, this.getTop(), this.m_307439_() - 2, this.m_306468_(), color);
        }
    }

    @Override
    protected void renderBg(@Nonnull GuiGraphics matrixStack, @Nonnull Minecraft mc, int mouseX, int mouseY) {
        if (this.isControlVisible()) {
            int hoverState = this.getYImage(this.isHoveringOrFocusingOver());
            String borderColor = hoverState == 2 ? "#FFFFFF" : "#000000";
            String contentColor = "#2b2b2b";
            RenderUtils.drawGradientBox(this.getControlPosX(), this.getControlPosY(), this.getBoxWidth(), this.getControlHeight(), this.getZLevel(), borderColor, borderColor, this.getBorderWidth(), "#2b2b2b", "#2b2b2b");
        }
    }

    @Override
    public void onClick() {
        this.setIsChecked(!this.is_Checked);
        super.onClick();
    }

    @Override
    public void setControlMessage(String newMessage) {
        super.setControlMessage(newMessage);
        this.syncRenderStates();
    }

    public boolean isChecked() {
        return this.is_Checked;
    }

    public void setIsChecked(boolean isChecked) {
        this.is_Checked = isChecked;
    }

    public int getBoxWidth() {
        return this.boxWidth;
    }

    public void setBoxWidth(int boxWidth) {
        this.boxWidth = boxWidth;
        this.syncRenderStates();
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
        this.syncRenderStates();
    }

    public int getMaxTextWidth() {
        return this.maxTextWidth;
    }

    public void setMaxTextWidth(int maxTextWidth) {
        this.maxTextWidth = maxTextWidth;
        this.syncRenderStates();
    }

    private void syncRenderStates() {
        this.setControlHeight(this.getBoxWidth());
        this.setControlWidth(this.getBoxWidth() + this.getBorderWidth() * 2 + this.getMaxTextWidth());
    }

    private void resetRenderStates() {
        this.setBoxWidth(11);
        this.setBorderWidth(1);
        this.setMaxTextWidth(167);
    }
}

