/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.controls;

import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class ExtendedButtonControl
extends Button
implements DynamicWidget {
    private String[] optionalArgs;
    private Runnable onPushEvent = null;
    private Runnable onHoverEvent = null;
    private boolean isOverScreen = false;

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        super(x, y, widthIn, heightIn, (Component)Component.m_237113_((String)buttonText), button -> {}, Button.f_252438_);
        this.optionalArgs = optionalArgs;
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.setOnClick(onPushEvent);
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.setOnHover(onHoverEvent);
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        this(ExtendedScreen.getNextIndex(), x, y, widthIn, heightIn, buttonText, optionalArgs);
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.setOnClick(onPushEvent);
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.setOnHover(onHoverEvent);
    }

    public ExtendedButtonControl(int id, int xPos, int yPos, String displayString) {
        this(id, xPos, yPos, 200, 20, displayString, new String[0]);
    }

    public ExtendedButtonControl(int xPos, int yPos, String displayString) {
        this(ExtendedScreen.getNextIndex(), xPos, yPos, displayString);
    }

    @Override
    public void preDraw(ExtendedScreen screen) {
        this.isOverScreen = RenderUtils.isMouseOver(screen);
    }

    @Override
    public void draw(ExtendedScreen screen) {
    }

    @Override
    public void postDraw(ExtendedScreen screen) {
        if (this.isOverScreen() && this.isHoveringOver()) {
            this.onHover();
        }
    }

    public void m_87963_(@Nonnull GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = ModUtils.getMinecraft();
        if (mc != null && this.isControlVisible()) {
            this.setHoveringOver(this.isOverScreen() && RenderUtils.isMouseOver((double)mouseX, (double)mouseY, this));
            this.renderBg(matrixStack, mc, mouseX, mouseY);
            int color = !this.isControlEnabled() ? 0xA0A0A0 : (this.isHoveringOrFocusingOver() ? 0xFFFFA0 : 0xE0E0E0);
            RenderUtils.renderScrollingString(matrixStack, mc, mc.f_91062_, this.getControlMessage(), this.getLeft() + 2, this.getTop(), this.m_307439_() - 2, this.m_306468_(), color);
        }
    }

    float getBlitOffset() {
        return 0.0f;
    }

    void setBlitOffset(int blitOffset) {
    }

    protected int getYImage(boolean hoveredOrFocused) {
        if (!this.f_93623_) {
            return 0;
        }
        if (this.m_198029_()) {
            return 2;
        }
        return 1;
    }

    protected void renderBg(@Nonnull GuiGraphics matrixStack, @Nonnull Minecraft mc, int mouseX, int mouseY) {
        if (this.isControlVisible()) {
            RenderUtils.renderSprite(matrixStack, graphics -> graphics.m_292816_(RenderUtils.getButtonTexture(this.isControlEnabled(), this.isHoveringOrFocusingOver()), this.getControlPosX(), this.getControlPosY(), this.getControlWidth(), this.getControlHeight()));
        }
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        return this.isOverScreen() && this.isControlEnabled() && this.isControlVisible() && this.isHoveringOver();
    }

    @Override
    public int getControlWidth() {
        return this.f_93618_;
    }

    @Override
    public void setControlWidth(int width) {
        this.f_93618_ = width;
    }

    @Override
    public int getControlHeight() {
        return this.f_93619_;
    }

    @Override
    public void setControlHeight(int height) {
        this.f_93619_ = height;
    }

    @Override
    public int getControlPosX() {
        return this.m_252754_();
    }

    @Override
    public void setControlPosX(int posX) {
        this.m_252865_(posX);
    }

    @Override
    public int getControlPosY() {
        return this.m_252907_();
    }

    @Override
    public void setControlPosY(int posY) {
        this.m_253211_(posY);
    }

    public boolean isOverScreen() {
        return this.isOverScreen;
    }

    public String[] getOptionalArgs() {
        return (String[])this.optionalArgs.clone();
    }

    public void setOnClick(Runnable event) {
        this.onPushEvent = event;
    }

    public void onClick() {
        if (this.onPushEvent != null) {
            this.onPushEvent.run();
        }
    }

    public void m_5691_() {
        this.onClick();
    }

    public void setOnHover(Runnable event) {
        this.onHoverEvent = event;
    }

    public void onHover() {
        if (this.onHoverEvent != null) {
            this.onHoverEvent.run();
        }
    }

    public Component getControlRawMessage() {
        return this.m_6035_();
    }

    public void setControlRawMessage(Component newMessage) {
        this.m_93666_(newMessage);
    }

    public String getControlMessage() {
        return this.getControlRawMessage().getString();
    }

    public void setControlMessage(String newMessage) {
        this.setControlRawMessage((Component)Component.m_237113_((String)newMessage));
    }

    public boolean isControlEnabled() {
        return this.f_93623_;
    }

    public void setControlEnabled(boolean isEnabled) {
        this.f_93623_ = isEnabled;
    }

    public boolean isControlVisible() {
        return this.f_93624_;
    }

    public void setControlVisible(boolean isVisible) {
        this.f_93624_ = isVisible;
    }

    public boolean isHoveringOver() {
        return this.f_93622_;
    }

    public void setHoveringOver(boolean isHovered) {
        this.f_93622_ = isHovered;
    }

    public boolean isFocusedOver() {
        return this.m_93696_();
    }

    public void setFocusedOver(boolean isFocused) {
        this.m_93692_(isFocused);
    }

    public boolean isHoveringOrFocusingOver() {
        return this.isHoveringOver() || this.isFocusedOver();
    }

    public double getZLevel() {
        return this.getBlitOffset();
    }

    public void setZLevel(double zLevel) {
        this.setBlitOffset((int)zLevel);
    }
}

