/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import unilib.external.com.twelvemonkeys.lang.Validate;

public final class SubStream
extends FilterInputStream {
    private long bytesLeft;
    private int markLimit;

    public SubStream(InputStream inputStream, long l2) {
        super(Validate.notNull(inputStream, "stream"));
        this.bytesLeft = Validate.isTrue(l2 >= 0L, l2, "length < 0: %s");
    }

    @Override
    public void close() throws IOException {
        while (this.bytesLeft > 0L && (this.skip(this.bytesLeft) > 0L || this.read() >= 0)) {
        }
    }

    @Override
    public int available() throws IOException {
        return (int)this.findMaxLen(super.available());
    }

    @Override
    public void mark(int n) {
        super.mark(n);
        this.markLimit = n;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.bytesLeft += (long)this.markLimit;
    }

    @Override
    public int read() throws IOException {
        if (this.bytesLeft-- <= 0L) {
            return -1;
        }
        return super.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.bytesLeft <= 0L) {
            return -1;
        }
        int n3 = super.read(byArray, n, (int)this.findMaxLen(n2));
        this.bytesLeft = n3 < 0 ? 0L : this.bytesLeft - (long)n3;
        return n3;
    }

    @Override
    public long skip(long l2) throws IOException {
        long l3 = super.skip(this.findMaxLen(l2));
        this.bytesLeft -= l3;
        return l3;
    }

    private long findMaxLen(long l2) {
        return this.bytesLeft < l2 ? Math.max(this.bytesLeft, 0L) : l2;
    }
}

