/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.nonapi.io.github.classgraph.classpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import unilib.external.nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandlerRegistry;
import unilib.external.nonapi.io.github.classgraph.reflection.ReflectionUtils;
import unilib.external.nonapi.io.github.classgraph.utils.LogNode;

public class ClassLoaderOrder {
    private final Map<ClassLoader, List<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry>> classLoaderOrder = new LinkedHashMap<ClassLoader, List<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry>>();
    public ReflectionUtils reflectionUtils;
    private final Set<ClassLoader> added = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<ClassLoader> delegatedTo = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<ClassLoader> allParentClassLoaders = Collections.newSetFromMap(new IdentityHashMap());

    public ClassLoaderOrder(ReflectionUtils reflectionUtils) {
        this.reflectionUtils = reflectionUtils;
    }

    public List<Map.Entry<ClassLoader, List<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry>>> getClassLoaderOrder() {
        return new ArrayList<Map.Entry<ClassLoader, List<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry>>>(this.classLoaderOrder.entrySet());
    }

    public Set<ClassLoader> getAllParentClassLoaders() {
        return this.allParentClassLoaders;
    }

    private static List<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> getClassLoaderHandlerRegistryEntries(ClassLoader classLoader, LogNode log) {
        ArrayList<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> ents = new ArrayList<ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry>();
        boolean matched = false;
        for (ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry ent : ClassLoaderHandlerRegistry.CLASS_LOADER_HANDLERS) {
            if (!ent.canHandle(classLoader.getClass(), log)) continue;
            ents.add(ent);
            matched = true;
        }
        if (!matched) {
            ents.add(ClassLoaderHandlerRegistry.FALLBACK_HANDLER);
        }
        return ents;
    }

    public void add(ClassLoader classLoader, LogNode log) {
        if (classLoader == null) {
            return;
        }
        if (this.added.add(classLoader)) {
            this.classLoaderOrder.put(classLoader, ClassLoaderOrder.getClassLoaderHandlerRegistryEntries(classLoader, log));
        }
    }

    public void delegateTo(ClassLoader classLoader, boolean isParent, LogNode log) {
        if (classLoader == null) {
            return;
        }
        if (isParent) {
            this.allParentClassLoaders.add(classLoader);
        }
        if (this.delegatedTo.add(classLoader)) {
            this.add(classLoader, log);
            for (ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry entry : ClassLoaderOrder.getClassLoaderHandlerRegistryEntries(classLoader, null)) {
                entry.findClassLoaderOrder(classLoader, this, log);
            }
        }
    }
}

