/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.imageio.stream;

import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import unilib.external.com.twelvemonkeys.lang.Validate;

public final class DirectImageInputStream
extends ImageInputStreamImpl {
    private final InputStream stream;
    private final long length;

    public DirectImageInputStream(InputStream inputStream) {
        this(inputStream, -1L);
    }

    public DirectImageInputStream(InputStream inputStream, long l2) {
        this.stream = Validate.notNull(inputStream, "stream");
        this.length = Validate.isTrue(l2 >= 0L || l2 == -1L, l2, "negative length: %d");
    }

    @Override
    public int read() throws IOException {
        this.bitOffset = 0;
        ++this.streamPos;
        return this.stream.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.bitOffset = 0;
        int n3 = this.stream.read(byArray, n, n2);
        if (n3 > 0) {
            this.streamPos += (long)n3;
        }
        return n3;
    }

    @Override
    public void seek(long l2) throws IOException {
        long l3;
        this.checkClosed();
        if (l2 < this.streamPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos");
        }
        this.bitOffset = 0;
        while (this.streamPos < l2 && (l3 = this.stream.skip(l2 - this.streamPos)) > 0L) {
            this.streamPos += l3;
        }
    }

    @Override
    public long getFlushedPosition() {
        return this.streamPos;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public int readBit() throws IOException {
        throw new UnsupportedOperationException("Bit reading not supported");
    }

    @Override
    public long readBits(int n) throws IOException {
        throw new UnsupportedOperationException("Bit reading not supported");
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
        super.close();
    }
}

