/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.imageio.stream;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import unilib.external.com.twelvemonkeys.lang.Validate;

public final class SubImageInputStream
extends ImageInputStreamImpl {
    private final ImageInputStream stream;
    private final long startPos;
    private final long length;

    public SubImageInputStream(ImageInputStream imageInputStream, long l2) throws IOException {
        Validate.notNull(imageInputStream, "stream");
        Validate.isTrue(l2 >= 0L, l2, "length < 0: %d");
        this.stream = imageInputStream;
        this.startPos = imageInputStream.getStreamPosition();
        this.length = l2;
    }

    @Override
    public int read() throws IOException {
        if (this.streamPos >= this.length) {
            return -1;
        }
        int n = this.stream.read();
        if (n >= 0) {
            ++this.streamPos;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.streamPos >= this.length) {
            return -1;
        }
        int n3 = (int)Math.min((long)n2, this.length - this.streamPos);
        int n4 = this.stream.read(byArray, n, n3);
        if (n4 >= 0) {
            this.streamPos += (long)n4;
        }
        return n4;
    }

    @Override
    public long length() {
        try {
            long l2 = this.stream.length();
            return l2 < 0L ? -1L : Math.min(l2 - this.startPos, this.length);
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @Override
    public void seek(long l2) throws IOException {
        if (l2 < this.getFlushedPosition()) {
            throw new IndexOutOfBoundsException("pos < flushedPosition");
        }
        this.stream.seek(this.startPos + l2);
        this.streamPos = l2;
    }

    @Override
    protected void finalize() {
    }
}

