/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.integrations;

import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.core.impl.screen.ScreenConstants;
import com.gitlab.cdagaming.unilib.utils.GameUtils;
import com.gitlab.cdagaming.unilib.utils.WorldUtils;
import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ScrollPane;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget;
import io.github.cdagaming.unicore.impl.Tuple;
import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ExtendedScreen
extends Screen
implements NarratableEntry {
    private static final int DEFAULT_ELEMENT_PADDING = 5;
    private static final int DEFAULT_ELEMENT_HEIGHT = 20;
    private static int lastIndex = 0;
    private final Screen currentScreen;
    private final List<GuiEventListener> extendedControls = StringUtils.newArrayList();
    private final List<DynamicWidget> extendedWidgets = StringUtils.newArrayList();
    private final List<AbstractSelectionList<?>> extendedLists = StringUtils.newArrayList();
    private GuiGraphics currentMatrix;
    private String title;
    private String subTitle;
    private Screen parentScreen;
    private Phase currentPhase = Phase.PREINIT;
    private int screenX = 0;
    private int screenY = 0;
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private float lastPartialTicks = 0.0f;
    private int lastMouseScroll = 0;
    private int contentHeight;
    private boolean canClose;
    private boolean isOverScreen;
    private boolean canModifyControls;

    public ExtendedScreen(Screen parentScreen, String title, String subTitle) {
        super((Component)Component.literal((String)""));
        this.setGameInstance(ModUtils.getMinecraft());
        this.setParent(parentScreen);
        this.currentScreen = this;
        this.setScreenTitle(title);
        this.setScreenSubTitle(subTitle);
        this.setCanClose(true);
        this.setCanModifyControls(true);
        this.setContentHeight(0);
        this.setScreenSettings();
    }

    public ExtendedScreen(Screen parentScreen, String title) {
        this(parentScreen, title, null);
    }

    public ExtendedScreen(Screen parentScreen) {
        this(parentScreen, null);
    }

    public ExtendedScreen(String title, String subTitle) {
        this(null, title, subTitle);
    }

    public ExtendedScreen(String title) {
        this(title, null);
    }

    public ExtendedScreen() {
        this((Screen)null);
    }

    public static int getNextIndex() {
        return lastIndex++;
    }

    public static void resetIndex() {
        lastIndex = 0;
    }

    public static void copyToClipboard(Minecraft instance, String input) {
        instance.keyboardHandler.setClipboard(StringUtils.normalize(input));
    }

    public static int getProtocol() {
        return ModUtils.MCProtocolID;
    }

    public static int getKeyByVersion(int lwjgl2Key, int lwjgl3Key) {
        return ExtendedScreen.getProtocol() > 340 ? lwjgl3Key : lwjgl2Key;
    }

    public static boolean isEscapeKey(int keyCode) {
        return keyCode == ExtendedScreen.getKeyByVersion(1, 256);
    }

    public static void enableRepeatEvents(Minecraft instance, boolean enable) {
    }

    public void copyToClipboard(String input) {
        ExtendedScreen.copyToClipboard(this.getGameInstance(), input);
    }

    public void enableRepeatEvents(boolean enable) {
        ExtendedScreen.enableRepeatEvents(this.getGameInstance(), enable);
    }

    public void init() {
        super.init();
        this.clearData();
        this.enableRepeatEvents(true);
        this.currentPhase = Phase.INIT;
        this.initializeUi();
        this.currentPhase = Phase.READY;
    }

    public void clearData() {
        if (!this.isUnloaded()) {
            this.currentPhase = Phase.PREINIT;
            this.setContentHeight(0);
            this.clearWidgets();
            this.extendedControls.clear();
            this.extendedWidgets.clear();
            this.extendedLists.clear();
        }
    }

    public void initializeUi() {
        if (this.isUnloaded()) {
            this.init(this.getGameInstance(), this.getScreenWidth(), this.getScreenHeight());
            return;
        }
        if (this.isInitializing()) {
            this.resetMouseScroll();
            this.constructElements();
            for (GuiEventListener extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.initializeUi();
            }
            this.appendElements();
            this.refreshContentHeight();
        }
    }

    public void constructElements() {
    }

    public void appendElements() {
    }

    public void reloadUi() {
        this.resize(this.getGameInstance(), this.getScreenWidth(), this.getScreenHeight());
    }

    public void resize(@Nonnull Minecraft mcIn, int w, int h) {
        if (this.isLoaded()) {
            for (GuiEventListener extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.resize(mcIn, w, h);
            }
        }
        super.resize(mcIn, w, h);
    }

    @Nonnull
    public <T extends GuiEventListener & Renderable> T addControl(@Nonnull T buttonIn) {
        if (!this.canModifyControls()) {
            throw new IllegalStateException("Can't add control to control list");
        }
        if (buttonIn instanceof DynamicWidget) {
            DynamicWidget widget = (DynamicWidget)buttonIn;
            if (!this.extendedWidgets.contains(buttonIn)) {
                this.addWidget(widget);
            }
        }
        if (!this.children().contains(buttonIn) && buttonIn instanceof ExtendedScreen) {
            super.addWidget(buttonIn);
        } else if (buttonIn instanceof Renderable) {
            this.addRenderableWidget(buttonIn);
        }
        if (!this.extendedControls.contains(buttonIn)) {
            this.extendedControls.add(buttonIn);
        }
        return buttonIn;
    }

    @Nonnull
    public <T extends AbstractSelectionList<?>> T addList(@Nonnull T buttonIn) {
        if (!this.canModifyControls()) {
            throw new IllegalStateException("Can't add control to control list");
        }
        if (buttonIn instanceof Renderable) {
            this.addRenderableWidget((GuiEventListener)buttonIn);
        }
        if (!this.extendedLists.contains(buttonIn)) {
            this.extendedLists.add(buttonIn);
        }
        return buttonIn;
    }

    @Nonnull
    public <T extends DynamicWidget> T addWidget(@Nonnull T buttonIn) {
        if (!this.canModifyControls()) {
            throw new IllegalStateException("Can't add control to control list");
        }
        if (!this.extendedWidgets.contains(buttonIn)) {
            buttonIn.setControlPosY(this.getTop() + buttonIn.getTop());
            this.extendedWidgets.add(buttonIn);
        }
        return buttonIn;
    }

    public void renderCriticalData() {
        this.drawBackground(this.getLeft(), this.getRight(), this.getTop(), this.getBottom(), this.getOffset(), this.getTintFactor(), this.getScreenBackground());
    }

    public void drawBackground(double left, double right, double top, double bottom, double offset, float tintFactor, double u, double v, ScreenConstants.ColorData data) {
        tintFactor = MathUtils.clamp(tintFactor, 0.0f, 1.0f);
        Color startColor = StringUtils.offsetColor(data.startColor(), tintFactor);
        Color endColor = StringUtils.offsetColor(data.endColor(), tintFactor);
        if (StringUtils.isNullOrEmpty(data.texLocation())) {
            RenderUtils.drawGradient(left, right, top, bottom, data.colorLevel(), startColor, endColor);
        } else {
            Tuple<Boolean, String, ResourceLocation> textureData = RenderUtils.getTextureData(this.getGameInstance(), data.texLocation());
            boolean usingExternalTexture = textureData.getFirst();
            ResourceLocation texLocation = textureData.getThird();
            this.drawTexture(left, right, top, bottom, data.texLevel(), data.useFullTexture(), usingExternalTexture, offset, u, v, data.textureWidth(), data.textureHeight(), startColor, endColor, texLocation);
        }
    }

    public void drawBackground(double left, double right, double top, double bottom, double offset, float tintFactor, ScreenConstants.ColorData data) {
        this.drawBackground(left, right, top, bottom, offset, tintFactor, left, top, data);
    }

    public void drawTexture(double left, double right, double top, double bottom, double zLevel, boolean asFullTexture, boolean usingExternalTexture, double offset, double u, double v, double textureWidth, double textureHeight, Object startColorObj, Object endColorObj, ResourceLocation texLocation) {
        RenderUtils.drawTexture(this.getGameInstance(), left, right, top, bottom, zLevel, asFullTexture, usingExternalTexture, right - left, bottom - top, u, v + offset, textureWidth, textureHeight, startColorObj, endColorObj, texLocation);
    }

    public void drawTexture(double left, double right, double top, double bottom, double zLevel, boolean asFullTexture, boolean usingExternalTexture, double offset, double u, double v, Object startColorObj, Object endColorObj, ResourceLocation texLocation) {
        this.drawTexture(left, right, top, bottom, zLevel, asFullTexture, usingExternalTexture, offset, u, v, 32.0, 32.0, startColorObj, endColorObj, texLocation);
    }

    public void drawTexture(double left, double right, double top, double bottom, double zLevel, boolean usingExternalTexture, double offset, double u, double v, Object startColorObj, Object endColorObj, ResourceLocation texLocation) {
        this.drawTexture(left, right, top, bottom, zLevel, true, usingExternalTexture, offset, u, v, startColorObj, endColorObj, texLocation);
    }

    public void drawTexture(double left, double right, double top, double bottom, boolean usingExternalTexture, double offset, double u, double v, Object startColorObj, Object endColorObj, ResourceLocation texLocation) {
        this.drawTexture(left, right, top, bottom, 0.0, usingExternalTexture, offset, u, v, startColorObj, endColorObj, texLocation);
    }

    public boolean hasWorld() {
        return WorldUtils.getWorld(this.getGameInstance()) != null;
    }

    public String getScreenTitle() {
        return this.title;
    }

    public void setScreenTitle(String title) {
        this.title = title;
    }

    public String getScreenSubTitle() {
        return this.subTitle;
    }

    public void setScreenSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public float getTintFactor() {
        return 1.0f;
    }

    public ScreenConstants.ColorData getScreenBackground() {
        return this.hasWorld() ? ScreenConstants.DEFAULT_ALT_SCREEN_BACKGROUND : ScreenConstants.DEFAULT_SCREEN_BACKGROUND;
    }

    public ScreenConstants.TooltipData getTooltipData(boolean isTooltip) {
        return isTooltip ? ScreenConstants.getDefaultTooltip() : ScreenConstants.getEmptyTooltip();
    }

    public ScreenConstants.TooltipData getTooltipData() {
        return this.getTooltipData(true);
    }

    public double getOffset() {
        return 0.0;
    }

    public void preRender() {
        for (DynamicWidget widget : this.getWidgets()) {
            widget.preDraw(this);
        }
    }

    public void renderExtra() {
        this.renderStringData();
        for (DynamicWidget widget : this.getWidgets()) {
            widget.draw(this);
        }
    }

    public void renderStringData() {
        this.renderTitles(this.getScreenTitle(), this.getScreenSubTitle());
    }

    public void renderTitles(String title, String subTitle) {
        boolean hasSubTitle;
        boolean hasMainTitle = !StringUtils.isNullOrEmpty(title);
        boolean bl = hasSubTitle = !StringUtils.isNullOrEmpty(subTitle);
        if (hasMainTitle) {
            if (hasSubTitle) {
                this.renderScrollingString(title, 30, 2, this.getScreenWidth() - 30, 16, 0xFFFFFF);
                this.renderScrollingString(subTitle, 30, 16, this.getScreenWidth() - 30, 30, 0xFFFFFF);
            } else {
                this.renderScrollingString(title, 30, 0, this.getScreenWidth() - 30, 32, 0xFFFFFF);
            }
        }
    }

    public void postRender() {
        for (DynamicWidget widget : this.getWidgets()) {
            widget.postDraw(this);
        }
    }

    public void renderBackground(@Nonnull GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.currentMatrix = matrixStack;
        this.renderCriticalData();
    }

    public void render(@Nonnull GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.currentMatrix = matrixStack;
        if (this.isLoaded()) {
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.lastPartialTicks = partialTicks;
            this.isOverScreen = RenderUtils.isMouseOver((double)mouseX, (double)mouseY, this);
            this.preRender();
            RenderUtils.enableScissor(matrixStack, this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
            super.render(matrixStack, mouseX, mouseY, partialTicks);
            this.renderExtra();
            RenderUtils.disableScissor(matrixStack);
            for (GuiEventListener extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.renderWithTooltip(matrixStack, mouseX, mouseY, partialTicks);
            }
            this.postRender();
        }
    }

    public boolean isMouseOver(double d, double e) {
        return super.isMouseOver(d, e) && this.isLoaded() && this.isOverScreen;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.isLoaded()) {
            for (AbstractSelectionList<?> listControl : this.getLists()) {
                if (!listControl.mouseReleased(mouseX, mouseY, mouseButton)) continue;
                return true;
            }
            for (GuiEventListener extendedControl : this.getControls()) {
                ExtendedScreen extendedScreen;
                if (!(extendedControl instanceof ExtendedScreen) || !(extendedScreen = (ExtendedScreen)extendedControl).mouseReleased(mouseX, mouseY, mouseButton)) continue;
                return true;
            }
            return super.mouseReleased(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean mouseDragged(double mX, double mY, int mouseButton, double dragX, double dragY) {
        if (this.isLoaded()) {
            for (AbstractSelectionList<?> listControl : this.getLists()) {
                if (!listControl.mouseDragged(mX, mY, mouseButton, dragX, dragY)) continue;
                return true;
            }
            for (GuiEventListener extendedControl : this.getControls()) {
                ExtendedScreen extendedScreen;
                if (!(extendedControl instanceof ExtendedScreen) || !(extendedScreen = (ExtendedScreen)extendedControl).mouseDragged(mX, mY, mouseButton, dragX, dragY)) continue;
                return true;
            }
            return super.mouseDragged(mX, mY, mouseButton, dragX, dragY);
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.isLoaded()) {
            this.setMouseScroll((int)deltaY);
            for (AbstractSelectionList<?> listControl : this.getLists()) {
                if (!listControl.mouseScrolled(mouseX, mouseY, deltaX, deltaY)) continue;
                return true;
            }
            for (GuiEventListener extendedControl : this.getControls()) {
                ExtendedScreen extendedScreen;
                if (!(extendedControl instanceof ExtendedScreen) || !(extendedScreen = (ExtendedScreen)extendedControl).mouseScrolled(mouseX, mouseY, deltaX, deltaY)) continue;
                return true;
            }
            return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int mouseX, int mouseY) {
        if (this.isLoaded()) {
            if (this.isCurrentScreen()) {
                if (ExtendedScreen.isEscapeKey(keyCode) && this.canClose()) {
                    this.openScreen(this.getParent());
                    return true;
                }
                return super.keyPressed(keyCode, mouseX, mouseY);
            }
            if (this.getFocused() != null) {
                return this.getFocused().keyPressed(keyCode, mouseX, mouseY);
            }
        }
        return false;
    }

    public void tick() {
        if (this.isLoaded()) {
            for (GuiEventListener extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.tick();
            }
            super.tick();
        }
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public void removed() {
        if (this.isLoaded()) {
            for (GuiEventListener extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
                extendedScreen.removed();
            }
            this.clearData();
            ExtendedScreen.resetIndex();
            this.enableRepeatEvents(false);
        }
    }

    @Nonnull
    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(@Nonnull NarrationElementOutput arg) {
    }

    public Minecraft getGameInstance() {
        return this.minecraft;
    }

    public void setGameInstance(Minecraft instance) {
        this.minecraft = instance;
    }

    public void openScreen(Screen targetScreen) {
        RenderUtils.openScreen(this.getGameInstance(), targetScreen);
    }

    public void openScreen(ExtendedScreen targetScreen, Screen parentScreen, boolean setParent) {
        RenderUtils.openScreen(this.getGameInstance(), targetScreen, parentScreen, setParent);
    }

    public void openScreen(ExtendedScreen targetScreen, Screen parentScreen) {
        RenderUtils.openScreen(this.getGameInstance(), targetScreen, parentScreen);
    }

    public void openScreen(ExtendedScreen targetScreen) {
        this.openScreen(targetScreen, this.getInstance());
    }

    public int computeGuiScale() {
        return RenderUtils.computeGuiScale(this.getGameInstance());
    }

    public int getButtonY(int order) {
        int topPosition = this.getTop();
        Screen screen = this.getInstance();
        if (screen instanceof ScrollPane) {
            ScrollPane pane = (ScrollPane)screen;
            topPosition += pane.getPadding();
        }
        return topPosition + 5 * (order + 1) + 20 * order;
    }

    public int getButtonY(int order, int offset, boolean appendByOrder) {
        return this.getButtonY(order) + offset * (appendByOrder ? order : 1);
    }

    public int getButtonY(int order, int offset) {
        return this.getButtonY(order, offset, false);
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY, int maxWidth, int maxHeight, int maxTextWidth, boolean isCentered, boolean isTooltip, ScreenConstants.TooltipData colorInfo) {
        RenderUtils.drawMultiLineString(this.getGameInstance(), this.getCurrentMatrix(), textToInput, posX, posY, maxWidth, maxHeight, maxTextWidth, this.getFontRenderer(), isCentered, isTooltip, colorInfo);
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY, int maxWidth, int maxHeight, int maxTextWidth, boolean isCentered, boolean isTooltip) {
        this.drawMultiLineString(textToInput, posX, posY, maxWidth, maxHeight, maxTextWidth, isCentered, isTooltip, this.getTooltipData(isTooltip));
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY, int maxWidth, int maxHeight, int maxTextWidth) {
        this.drawMultiLineString(textToInput, posX, posY, maxWidth, maxHeight, maxTextWidth, false, true);
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY) {
        this.drawMultiLineString(textToInput, posX, posY, this.getScreenWidth(), this.getScreenHeight(), this.getWrapWidth());
    }

    public void drawMultiLineString(List<String> textToInput) {
        this.drawMultiLineString(textToInput, this.getMouseX(), this.getMouseY());
    }

    public void renderScrollingString(String message, float centerX, float minX, float minY, float maxX, float maxY, int color) {
        RenderUtils.renderScrollingString(this.getCurrentMatrix(), this.getGameInstance(), this.getFontRenderer(), message, centerX, minX, minY, maxX, maxY, color);
    }

    public void renderScrollingString(String message, int centerX, int minX, int minY, int maxX, int maxY, int color) {
        RenderUtils.renderScrollingString(this.getCurrentMatrix(), this.getGameInstance(), this.getFontRenderer(), message, centerX, minX, minY, maxX, maxY, color);
    }

    public void renderScrollingString(String message, float minX, float minY, float maxX, float maxY, int color) {
        this.renderScrollingString(message, maxX - (maxX - minX) / 2.0f, minX, minY, maxX, maxY, color);
    }

    public void renderScrollingString(String message, int minX, int minY, int maxX, int maxY, int color) {
        this.renderScrollingString(message, maxX - (maxX - minX) / 2, minX, minY, maxX, maxY, color);
    }

    public void renderCenteredString(String text, float xPos, float yPos, int color) {
        RenderUtils.renderCenteredString(this.getCurrentMatrix(), this.getFontRenderer(), text, xPos, yPos, color);
    }

    public void renderCenteredString(String text, int xPos, int yPos, int color) {
        RenderUtils.renderCenteredString(this.getCurrentMatrix(), this.getFontRenderer(), text, xPos, yPos, color);
    }

    public void renderCenteredString(String text, float yPos, int color) {
        this.renderCenteredString(text, (float)this.getScreenWidth() / 2.0f, yPos, color);
    }

    public void renderCenteredString(String text, int yPos, int color) {
        this.renderCenteredString(text, this.getScreenWidth() / 2, yPos, color);
    }

    public void renderString(String text, float xPos, float yPos, int color) {
        RenderUtils.renderString(this.getCurrentMatrix(), this.getFontRenderer(), text, xPos, yPos, color);
    }

    public void renderString(String text, int xPos, int yPos, int color) {
        this.renderString(text, (float)xPos, (float)yPos, color);
    }

    public int getStringWidth(String string) {
        return RenderUtils.getStringWidth(this.getFontRenderer(), string);
    }

    public List<String> createRenderLines(List<String> original, int wrapWidth) {
        List<String> data = StringUtils.newArrayList();
        for (String line : original) {
            data.addAll(RenderUtils.listFormattedStringToWidth(this.getFontRenderer(), line, wrapWidth));
        }
        return data;
    }

    public List<String> createRenderLines(String original, int wrapWidth) {
        return this.createRenderLines(StringUtils.splitTextByNewLine(original, true), wrapWidth);
    }

    public int getWrapWidth() {
        return -1;
    }

    public int getMouseX() {
        return this.lastMouseX;
    }

    public int getMouseY() {
        return this.lastMouseY;
    }

    public float getPartialTicks() {
        return this.lastPartialTicks;
    }

    public int getScreenX() {
        return this.screenX;
    }

    public void setScreenX(int screenX) {
        this.screenX = screenX;
    }

    public int getScreenY() {
        return this.screenY;
    }

    public void setScreenY(int screenY) {
        this.screenY = screenY;
    }

    public boolean isOverScreen() {
        return this.isOverScreen;
    }

    public boolean isCurrentScreen() {
        return GameUtils.getCurrentScreen(this.getGameInstance()) == this;
    }

    public int getMouseScroll() {
        return this.lastMouseScroll;
    }

    public void setMouseScroll(int mouseScroll) {
        this.lastMouseScroll = mouseScroll;
    }

    public void resetMouseScroll() {
        this.setMouseScroll(0);
    }

    public int getMaxWidth() {
        return this.getScreenWidth();
    }

    public void setScreenSettings() {
    }

    public int getScreenWidth() {
        return this.width;
    }

    public void setScreenWidth(int screenWidth) {
        this.width = screenWidth;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public void setContentHeight(int contentHeight) {
        this.contentHeight = contentHeight;
    }

    public void refreshContentHeight() {
        this.setContentHeight(0);
        for (DynamicWidget widget : this.getWidgets()) {
            int widgetHeight = widget.getBottom();
            if (widgetHeight <= this.getContentHeight()) continue;
            this.setContentHeight(widgetHeight);
        }
        for (GuiEventListener extendedControl : this.getControls()) {
            if (!(extendedControl instanceof ExtendedScreen)) continue;
            ExtendedScreen extendedScreen = (ExtendedScreen)extendedControl;
            extendedScreen.refreshContentHeight();
        }
    }

    public int getScreenHeight() {
        return this.height;
    }

    public void setScreenHeight(int screenHeight) {
        this.height = screenHeight;
    }

    public Font getFontRenderer() {
        return StringUtils.getOrDefault(this.getGameInstance().font, RenderUtils.getDefaultFontRenderer());
    }

    public int getFontHeight() {
        return RenderUtils.getFontHeight(this.getFontRenderer());
    }

    public int getLeft() {
        return this.getScreenX();
    }

    public int getRight() {
        return this.getScreenX() + this.getScreenWidth();
    }

    public int getBottom() {
        return this.getScreenY() + this.getScreenHeight();
    }

    public int getTop() {
        return this.getScreenY();
    }

    public GuiGraphics getCurrentMatrix() {
        return this.currentMatrix;
    }

    public Screen getInstance() {
        return this.currentScreen;
    }

    public Screen getParent() {
        return this.parentScreen;
    }

    public void setParent(Screen parentScreen) {
        this.parentScreen = parentScreen;
    }

    public boolean canClose() {
        return this.canClose;
    }

    public void setCanClose(boolean canClose) {
        this.canClose = canClose;
    }

    public boolean canModifyControls() {
        return this.canModifyControls;
    }

    public void setCanModifyControls(boolean canModifyControls) {
        this.canModifyControls = canModifyControls;
    }

    public List<GuiEventListener> getControls() {
        return StringUtils.newArrayList(this.extendedControls);
    }

    public List<DynamicWidget> getWidgets() {
        return StringUtils.newArrayList(this.extendedWidgets);
    }

    public List<AbstractSelectionList<?>> getLists() {
        return StringUtils.newArrayList(this.extendedLists);
    }

    public boolean isLoaded() {
        return this.currentPhase == Phase.READY;
    }

    public boolean isInitializing() {
        return this.currentPhase == Phase.INIT;
    }

    public boolean isUnloaded() {
        return this.currentPhase == Phase.PREINIT;
    }

    public static enum Phase {
        PREINIT,
        INIT,
        READY;

    }
}

