/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ItemUtils {
    public static final Item EMPTY_ITEM = null;
    public static final ItemStack EMPTY_STACK = ItemStack.EMPTY;
    private static final List<Item> EMPTY_ITEMS = StringUtils.newArrayList(EMPTY_ITEM, Items.AIR);

    public static ItemStack getStackFrom(Object data) {
        ItemStack itemStack = null;
        if (data != null) {
            if (data instanceof Block) {
                Block block = (Block)data;
                data = ItemUtils.getDefaultInstance(block);
            }
            if (data instanceof Item) {
                Item item = (Item)data;
                data = ItemUtils.getDefaultInstance(item);
            }
            if (data instanceof ItemStack) {
                ItemStack stack;
                itemStack = stack = (ItemStack)data;
            }
        }
        return itemStack;
    }

    public static Item getItemFromStack(ItemStack stack) {
        return stack != null ? stack.getItem() : EMPTY_ITEM;
    }

    public static int getStackCount(ItemStack stack) {
        return stack != null ? stack.getCount() : 0;
    }

    public static int getStackDamage(ItemStack stack) {
        return stack != null ? stack.getDamageValue() : 0;
    }

    public static boolean isItemEmpty(Object data) {
        ItemStack stack = ItemUtils.getStackFrom(data);
        if (stack == null || stack.equals(EMPTY_STACK)) {
            return true;
        }
        return EMPTY_ITEMS.contains(ItemUtils.getItemFromStack(stack)) || ItemUtils.getStackCount(stack) <= 0 || !MathUtils.isWithinValue(ItemUtils.getStackDamage(stack), -32768.0, 65535.0);
    }

    public static ItemStack getDefaultInstance(Block block) {
        return new ItemStack((ItemLike)block);
    }

    public static ItemStack getDefaultInstance(Item item) {
        return new ItemStack((ItemLike)item);
    }

    public static String getItemName(Object data, boolean stripFormatting) {
        ItemStack stack = ItemUtils.getStackFrom(data);
        String result = "";
        if (!ItemUtils.isItemEmpty(stack)) {
            result = StringUtils.getOrDefault(stack.getHoverName().getString());
        }
        if (stripFormatting) {
            result = StringUtils.stripAllFormatting(result);
        }
        return result;
    }

    public static String getItemName(Object data) {
        return ItemUtils.getItemName(data, true);
    }

    public static boolean isRawTE(String name) {
        if (!StringUtils.isNullOrEmpty(name)) {
            String lowerName = name.toLowerCase();
            return lowerName.contains("tile.") || lowerName.contains("item.") || lowerName.contains(".") || lowerName.contains(".name");
        }
        return false;
    }
}

