/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.core.CoreUtils;
import com.gitlab.cdagaming.unilib.core.impl.KeyConverter;
import com.gitlab.cdagaming.unilib.utils.GameUtils;
import com.mojang.blaze3d.platform.InputConstants;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.options.controls.ControlsScreen;
import org.lwjgl.glfw.GLFW;

public class KeyUtils {
    public static final KeyUtils INSTANCE = new KeyUtils();
    public final Map<String, Integer> keySyncQueue = StringUtils.newHashMap();
    private final Map<String, KeyBindData> registrationQueue = StringUtils.newConcurrentHashMap();
    private final Map<String, KeyBindData> KEY_MAPPINGS = StringUtils.newHashMap();
    private final Supplier<Minecraft> instance;
    private final int protocol;

    public KeyUtils(Supplier<Minecraft> instance, int protocol) {
        this.instance = instance;
        this.protocol = protocol;
    }

    public KeyUtils() {
        this(ModUtils.getMinecraftSupplier(), ModUtils.MCProtocolID);
    }

    public Minecraft getInstance() {
        return this.instance.get();
    }

    public boolean isValidKeyCode(int sourceKeyCode) {
        return KeyConverter.isValidKeyCode(sourceKeyCode, this.protocol);
    }

    public boolean isValidClearCode(int sourceKeyCode) {
        return KeyConverter.isValidClearCode(sourceKeyCode, this.protocol);
    }

    public String getKeyName(int original) {
        return KeyConverter.getKeyName(original, this.protocol, (originalKeyCode, inputProtocol) -> GLFW.glfwGetKeyName((int)originalKeyCode, (int)GLFW.glfwGetKeyScancode((int)originalKeyCode)));
    }

    private KeyMapping createKey(String id, String name, String category, int defaultKey, int currentKey) {
        KeyMapping result = new KeyMapping(name, defaultKey, category);
        this.keySyncQueue.put(id, currentKey);
        return result;
    }

    public KeyMapping registerKey(String id, String name, Function<String, String> nameFormatter, String category, Function<String, String> categoryFormatter, int defaultKey, int currentKey, Supplier<String> detailsSupplier, Supplier<Boolean> canCheckSupplier, Supplier<Boolean> canSyncSupplier, Runnable onPress, BiConsumer<Integer, Boolean> onBind, Predicate<Integer> onOutdated, BiFunction<Throwable, Pair<String, KeyBindData>, Boolean> callback) {
        KeyMapping keyBind = this.createKey(id, name, category, defaultKey, currentKey);
        KeyBindData keyData = new KeyBindData(keyBind, nameFormatter, () -> ((KeyMapping)keyBind).getCategory(), categoryFormatter, () -> keyBind.getDefaultKey().getValue(), detailsSupplier, canCheckSupplier, canSyncSupplier, onPress, onBind, onOutdated, callback);
        this.KEY_MAPPINGS.put(id, keyData);
        this.registrationQueue.put(id, keyData);
        return keyBind;
    }

    public KeyMapping registerKey(String id, String name, String category, int defaultKey, int currentKey, Supplier<String> detailsSupplier, Supplier<Boolean> canCheckSupplier, Supplier<Boolean> canSyncSupplier, Runnable onPress, BiConsumer<Integer, Boolean> onBind, Predicate<Integer> onOutdated, BiFunction<Throwable, Pair<String, KeyBindData>, Boolean> callback) {
        return this.registerKey(id, name, description -> description, category, categoryName -> categoryName, defaultKey, currentKey, detailsSupplier, canCheckSupplier, canSyncSupplier, onPress, onBind, onOutdated, callback);
    }

    public KeyMapping registerKey(String id, String name, String category, int defaultKey, int currentKey, Supplier<Boolean> canCheckSupplier, Supplier<Boolean> canSyncSupplier, Runnable onPress, BiConsumer<Integer, Boolean> onBind, Predicate<Integer> onOutdated, BiFunction<Throwable, Pair<String, KeyBindData>, Boolean> callback) {
        return this.registerKey(id, name, category, defaultKey, currentKey, () -> "", canCheckSupplier, canSyncSupplier, onPress, onBind, onOutdated, callback);
    }

    private void setKey(KeyMapping instance, int newKey) {
        boolean isLwjgl2 = this.protocol <= 340;
        int unknownKeyCode = isLwjgl2 ? -1 : 0;
        String unknownKeyName = (isLwjgl2 ? KeyConverter.fromGlfw : KeyConverter.toGlfw).get(unknownKeyCode).name();
        InputConstants.Key inputKey = this.getKeyName(newKey).equals(unknownKeyName) ? InputConstants.UNKNOWN : InputConstants.getKey((int)newKey, (int)GLFW.glfwGetKeyScancode((int)newKey));
        instance.setKey(inputKey);
        KeyMapping.resetMapping();
    }

    public boolean areKeysRegistered() {
        return this.registrationQueue.isEmpty();
    }

    public Set<Map.Entry<String, KeyBindData>> getRegistrationEntries() {
        return this.registrationQueue.entrySet();
    }

    public Set<String> getKeys() {
        return this.KEY_MAPPINGS.keySet();
    }

    public Set<Map.Entry<String, KeyBindData>> getKeyEntries() {
        return this.KEY_MAPPINGS.entrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTick() {
        if (this.instance == null || this.getInstance() == null) {
            return;
        }
        if (!this.areKeysRegistered()) {
            if (this.getInstance().options != null) {
                Iterator<Map.Entry<String, KeyBindData>> iterator = this.getRegistrationEntries().iterator();
                while (iterator.hasNext()) {
                    Map map = KeyMapping.CATEGORY_SORT_ORDER;
                    Map.Entry<String, KeyBindData> data = iterator.next();
                    KeyBindData entry = data.getValue();
                    String category = entry.category();
                    if (!map.containsKey(category)) {
                        Optional largest = map.values().stream().max(Integer::compareTo);
                        int largestInt = largest.orElse(0);
                        map.put(category, largestInt + 1);
                    }
                    this.getInstance().options.keyMappings = StringUtils.addToArray(this.getInstance().options.keyMappings, entry.binding());
                    this.registrationQueue.remove(data.getKey());
                }
            } else {
                return;
            }
        }
        if (this.getInstance().getWindow() != null) {
            boolean isLwjgl2 = this.protocol <= 340;
            int unknownKeyCode = isLwjgl2 ? -1 : 0;
            String unknownKeyName = (isLwjgl2 ? KeyConverter.fromGlfw : KeyConverter.toGlfw).get(unknownKeyCode).name();
            try {
                for (Map.Entry entry : this.getKeyEntries()) {
                    String keyName = (String)entry.getKey();
                    KeyBindData keyData = (KeyBindData)entry.getValue();
                    if (!keyData.canCheck()) continue;
                    int currentBind = keyData.keyCode();
                    boolean hasBeenRun = false;
                    if (!(this.getKeyName(currentBind).equals(unknownKeyName) || this.isValidClearCode(currentBind) || GLFW.glfwGetKey((long)this.getInstance().getWindow().getWindow(), (int)currentBind) != 1 || GameUtils.getCurrentScreen(this.getInstance()) instanceof ControlsScreen)) {
                        try {
                            keyData.runEvent().run();
                        }
                        catch (Throwable ex) {
                            boolean resetKey;
                            if (keyData.errorCallback() != null) {
                                resetKey = keyData.errorCallback().apply(ex, new Pair<String, KeyBindData>(keyName, keyData));
                            } else {
                                CoreUtils.LOG.error(ex);
                                resetKey = true;
                            }
                            if (resetKey) {
                                this.syncKeyData(keyName, ImportMode.Specific, keyData.defaultKeyCode());
                            }
                        }
                        finally {
                            hasBeenRun = true;
                        }
                    }
                    if (hasBeenRun || !keyData.canSync()) continue;
                    if (this.keySyncQueue.containsKey(keyName)) {
                        this.syncKeyData(keyName, ImportMode.Config, this.keySyncQueue.get(keyName));
                        this.keySyncQueue.remove(keyName);
                        continue;
                    }
                    if (!keyData.vanillaPredicate().test(currentBind)) continue;
                    this.syncKeyData(keyName, ImportMode.Vanilla, currentBind);
                }
            }
            catch (Throwable ex) {
                CoreUtils.LOG.debugError(ex);
            }
        }
    }

    private void syncKeyData(String keyName, ImportMode mode, int keyCode) {
        KeyBindData keyData = this.KEY_MAPPINGS.getOrDefault(keyName, null);
        if (mode == ImportMode.Config) {
            this.setKey(keyData.binding(), keyCode);
        } else if (mode == ImportMode.Vanilla) {
            keyData.configEvent().accept(keyCode, true);
        } else if (mode == ImportMode.Specific) {
            this.syncKeyData(keyData.description(), ImportMode.Config, keyCode);
            this.syncKeyData(keyName, ImportMode.Vanilla, keyCode);
        }
    }

    public Map<String, KeyBindData> getKeyMappings(List<String> filterData) {
        Map<String, KeyBindData> filteredMappings = StringUtils.newHashMap();
        if (filterData == null || filterData.isEmpty()) {
            filteredMappings.putAll(this.KEY_MAPPINGS);
            return filteredMappings;
        }
        for (Map.Entry<String, KeyBindData> entry : this.getKeyEntries()) {
            String keyName = entry.getKey();
            KeyBindData keyData = entry.getValue();
            if (!filterData.contains(keyData.rawCategoryName())) continue;
            filteredMappings.put(keyName, keyData);
        }
        return filteredMappings;
    }

    public Map<String, KeyBindData> getKeyMappings(String ... filterData) {
        return this.getKeyMappings(filterData == null || filterData.length == 0 ? null : StringUtils.newArrayList(filterData));
    }

    public record KeyBindData(KeyMapping binding, Function<String, String> nameFormatter, Supplier<String> categorySupplier, Function<String, String> categoryFormatter, Supplier<Integer> defaultKeySupplier, Supplier<String> detailsSupplier, Supplier<Boolean> canCheckSupplier, Supplier<Boolean> canSyncSupplier, Runnable runEvent, BiConsumer<Integer, Boolean> configEvent, Predicate<Integer> vanillaPredicate, BiFunction<Throwable, Pair<String, KeyBindData>, Boolean> errorCallback) {
        public String category() {
            return this.categorySupplier().get();
        }

        public String rawCategoryName() {
            return this.category();
        }

        public String categoryName() {
            return this.categoryFormatter().apply(this.rawCategoryName());
        }

        public String details() {
            return this.detailsSupplier().get();
        }

        public boolean canCheck() {
            return this.canCheckSupplier.get();
        }

        public boolean canSync() {
            return this.canSyncSupplier.get();
        }

        public String description() {
            return this.binding().getName();
        }

        public String displayName() {
            return this.nameFormatter().apply(this.description());
        }

        public int keyCode() {
            return this.binding().key.getValue();
        }

        public int defaultKeyCode() {
            return this.defaultKeySupplier().get();
        }
    }

    public static enum ImportMode {
        Config,
        Vanilla,
        Specific;

    }
}

