/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.widgets;

import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ScrollPane;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import java.util.Objects;

public class TextDisplayWidget
implements DynamicWidget {
    private boolean needsUpdate = false;
    private int startX;
    private int startY;
    private int width;
    private int contentHeight;
    private String message;
    private List<String> renderLines;
    private boolean centered;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public TextDisplayWidget(boolean centered, int startX, int startY, int width, String message) {
        this.setCentered(centered);
        this.setControlPosX(startX);
        this.setControlPosY(startY);
        this.setControlWidth(width);
        this.setMessage(message);
    }

    public TextDisplayWidget(int startX, int startY, int width, String message) {
        this(false, startX, startY, width, message);
    }

    public TextDisplayWidget(boolean centered, int startX, int startY, int width) {
        this(centered, startX, startY, width, "");
    }

    public TextDisplayWidget(int startX, int startY, int width) {
        this(false, startX, startY, width);
    }

    public TextDisplayWidget(boolean centered, int width, String message) {
        this(centered, 0, 0, width, message);
    }

    public TextDisplayWidget(int width, String message) {
        this(false, width, message);
    }

    public TextDisplayWidget(boolean centered, int width) {
        this(centered, width, "");
    }

    public TextDisplayWidget(int width) {
        this(false, width);
    }

    public String getMessage() {
        return this.message;
    }

    public TextDisplayWidget setMessage(String newMessage) {
        if (!Objects.equals(newMessage, this.message)) {
            this.message = newMessage;
            this.needsUpdate = true;
        }
        return this;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public TextDisplayWidget setCentered(boolean centered) {
        this.centered = centered;
        return this;
    }

    public List<String> getRenderLines() {
        return StringUtils.newArrayList(this.renderLines);
    }

    @Override
    public void preDraw(ExtendedScreen screen) {
        if (this.needsUpdate) {
            this.renderLines = this.refreshContent(screen);
            this.needsUpdate = false;
        }
    }

    @Override
    public void draw(ExtendedScreen screen) {
        int padding = 0;
        int barWidth = 0;
        if (screen instanceof ScrollPane) {
            ScrollPane pane = (ScrollPane)screen;
            padding = pane.getPadding();
            barWidth = pane.getScrollBarWidth();
        }
        screen.drawMultiLineString(this.getRenderLines(), this.getControlPosX() + padding, this.getControlPosY() + padding, this.getControlWidth() - padding - barWidth, -1, -1, this.isCentered(), false);
    }

    @Override
    public void postDraw(ExtendedScreen screen) {
    }

    @Override
    public int getControlPosX() {
        return this.startX;
    }

    @Override
    public void setControlPosX(int posX) {
        this.startX = posX;
    }

    @Override
    public int getControlPosY() {
        return this.startY;
    }

    @Override
    public void setControlPosY(int posY) {
        this.startY = posY;
    }

    @Override
    public int getControlWidth() {
        return this.width;
    }

    @Override
    public void setControlWidth(int width) {
        this.width = width;
    }

    @Override
    public int getControlHeight() {
        return this.contentHeight;
    }

    @Override
    public void setControlHeight(int height) {
        this.contentHeight = height;
    }

    public List<String> refreshContent(ExtendedScreen screen) {
        int padding = 0;
        int barWidth = 0;
        if (screen instanceof ScrollPane) {
            ScrollPane pane = (ScrollPane)screen;
            padding = pane.getPadding();
            barWidth = pane.getScrollBarWidth();
        }
        int width = MathUtils.clamp(this.getControlWidth() - this.getControlPosX() - padding * 2 - barWidth, 0, screen.getMaxWidth());
        List<String> content = screen.createRenderLines(this.getMessage(), width);
        int height = content.size() * (screen.getFontHeight() + 1);
        this.setControlHeight(height + 2);
        screen.refreshContentHeight();
        return content;
    }
}

