/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.io;

import java.io.IOException;
import java.io.InputStream;
import unilib.external.com.twelvemonkeys.io.SeekableInputStream;
import unilib.external.com.twelvemonkeys.lang.Validate;

abstract class AbstractCachedSeekableStream
extends SeekableInputStream {
    protected final InputStream stream;
    protected long streamPosition;
    private StreamCache cache;

    protected AbstractCachedSeekableStream(InputStream inputStream, StreamCache streamCache) {
        Validate.notNull(inputStream, "stream");
        Validate.notNull(streamCache, "cache");
        this.stream = inputStream;
        this.cache = streamCache;
    }

    protected final StreamCache getCache() {
        return this.cache;
    }

    @Override
    public int available() throws IOException {
        long l = this.streamPosition - this.position + (long)this.stream.available();
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    @Override
    public int read() throws IOException {
        int n2;
        this.checkOpen();
        if (this.position == this.streamPosition) {
            n2 = this.stream.read();
            if (n2 >= 0) {
                ++this.streamPosition;
                this.cache.write(n2);
            }
        } else {
            this.syncPosition();
            n2 = this.cache.read();
        }
        if (n2 != -1) {
            ++this.position;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        this.checkOpen();
        if (this.position == this.streamPosition) {
            n4 = this.stream.read(byArray, n2, n3);
            if (n4 > 0) {
                this.streamPosition += (long)n4;
                this.cache.write(byArray, n2, n4);
            }
        } else {
            this.syncPosition();
            n4 = this.cache.read(byArray, n2, n3);
        }
        if (n4 > 0) {
            this.position += (long)n4;
        }
        return n4;
    }

    protected final void syncPosition() throws IOException {
        if (this.cache.getPosition() != this.position) {
            this.cache.seek(this.position);
        }
    }

    @Override
    public final boolean isCached() {
        return true;
    }

    @Override
    public abstract boolean isCachedMemory();

    @Override
    public abstract boolean isCachedFile();

    @Override
    protected void seekImpl(long l) throws IOException {
        if (this.streamPosition < l) {
            long l2;
            if (this.cache.getPosition() != this.streamPosition) {
                this.cache.seek(this.streamPosition);
            }
            int n2 = (l2 = l - this.streamPosition) > 1024L ? 1024 : (int)l2;
            byte[] byArray = new byte[n2];
            while (l2 > 0L) {
                int n3 = (long)byArray.length < l2 ? byArray.length : (int)l2;
                int n4 = this.stream.read(byArray, 0, n3);
                if (n4 > 0) {
                    this.cache.write(byArray, 0, n4);
                    this.streamPosition += (long)n4;
                    l2 -= (long)n4;
                    continue;
                }
                if (n4 >= 0) continue;
                break;
            }
        } else {
            this.cache.seek(l);
        }
    }

    @Override
    protected void flushBeforeImpl(long l) {
        this.cache.flush(l);
    }

    @Override
    protected void closeImpl() throws IOException {
        this.cache.close();
        this.cache = null;
        this.stream.close();
    }

    static abstract class StreamCache {
        StreamCache() {
        }

        abstract void write(int var1) throws IOException;

        void write(byte[] byArray, int n2, int n3) throws IOException {
            for (int i = 0; i < n3; ++i) {
                this.write(byArray[n2 + i]);
            }
        }

        abstract int read() throws IOException;

        int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4;
            int n5 = 0;
            for (int i = 0; i < n3 && (n4 = this.read()) >= 0; ++i) {
                byArray[n2 + i] = (byte)n4;
                ++n5;
            }
            return n5;
        }

        abstract void seek(long var1) throws IOException;

        void flush(long l) {
        }

        abstract long getPosition() throws IOException;

        abstract void close() throws IOException;
    }
}

