/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import unilib.external.com.twelvemonkeys.io.AbstractCachedSeekableStream;

public final class MemoryCacheSeekableStream
extends AbstractCachedSeekableStream {
    public MemoryCacheSeekableStream(InputStream inputStream) {
        super(inputStream, new MemoryCache());
    }

    @Override
    public final boolean isCachedMemory() {
        return true;
    }

    @Override
    public final boolean isCachedFile() {
        return false;
    }

    static final class MemoryCache
    extends AbstractCachedSeekableStream.StreamCache {
        static final int BLOCK_SIZE = 8192;
        private final List<byte[]> cache = new ArrayList<byte[]>();
        private long length;
        private long position;
        private long start;

        MemoryCache() {
        }

        private byte[] getBlock() throws IOException {
            long l = this.position - this.start;
            if (l < 0L) {
                throw new IOException("StreamCache flushed before read position");
            }
            long l2 = l / 8192L;
            if (l2 >= Integer.MAX_VALUE) {
                throw new IOException("Memory cache max size exceeded");
            }
            if (l2 >= (long)this.cache.size()) {
                try {
                    this.cache.add(new byte[8192]);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw new IOException("No more memory for cache: " + this.cache.size() * 8192);
                }
            }
            return this.cache.get((int)l2);
        }

        @Override
        public void write(int n2) throws IOException {
            byte[] byArray = this.getBlock();
            int n3 = (int)(this.position % 8192L);
            byArray[n3] = (byte)n2;
            ++this.position;
            if (this.position > this.length) {
                this.length = this.position;
            }
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            byte[] byArray2 = this.getBlock();
            for (int i = 0; i < n3; ++i) {
                int n4 = (int)this.position % 8192;
                if (n4 == 0) {
                    byArray2 = this.getBlock();
                }
                byArray2[n4] = byArray[n2 + i];
                ++this.position;
            }
            if (this.position > this.length) {
                this.length = this.position;
            }
        }

        @Override
        public int read() throws IOException {
            if (this.position >= this.length) {
                return -1;
            }
            byte[] byArray = this.getBlock();
            int n2 = (int)(this.position % 8192L);
            ++this.position;
            return byArray[n2] & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4;
            if (this.position >= this.length) {
                return -1;
            }
            byte[] byArray2 = this.getBlock();
            int n5 = (int)(this.position % 8192L);
            int n6 = (int)Math.min((long)Math.min(n3, byArray2.length - n5), this.length - this.position);
            for (n4 = 0; n4 < n6; ++n4) {
                byArray[n2 + n4] = byArray2[n5 + n4];
            }
            this.position += (long)n4;
            return n4;
        }

        @Override
        public void seek(long l) throws IOException {
            if (l < this.start) {
                throw new IOException("Seek before flush position");
            }
            this.position = l;
        }

        @Override
        public void flush(long l) {
            int n2 = (int)(l / 8192L) - 1;
            for (int i = 0; i < n2; ++i) {
                this.cache.remove(0);
            }
            this.start = l;
        }

        @Override
        void close() throws IOException {
            this.cache.clear();
        }

        @Override
        public long getPosition() {
            return this.position;
        }
    }
}

