/*
 * Decompiled with CFR 0.152.
 */
package unilib.external.com.twelvemonkeys.io.enc;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import unilib.external.com.twelvemonkeys.io.enc.Decoder;

public final class DecoderStream
extends FilterInputStream {
    private final ByteBuffer buffer;
    private final Decoder decoder;

    public DecoderStream(InputStream inputStream, Decoder decoder) {
        this(inputStream, decoder, 1024);
    }

    public DecoderStream(InputStream inputStream, Decoder decoder, int n2) {
        super(inputStream);
        this.decoder = decoder;
        this.buffer = ByteBuffer.allocate(n2);
        this.buffer.flip();
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }

    @Override
    public int read() throws IOException {
        if (!this.buffer.hasRemaining() && this.fill() < 0) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException("bytes.length=" + byArray.length + " offset=" + n2 + " length=" + n3);
        }
        if (n3 == 0) {
            return 0;
        }
        if (!this.buffer.hasRemaining() && this.fill() < 0) {
            return -1;
        }
        int n6 = n2;
        for (n4 = 0; n3 > n4 && (this.buffer.hasRemaining() || this.fill() >= 0); n4 += n5) {
            n5 = Math.min(n3 - n4, this.buffer.remaining());
            this.buffer.get(byArray, n6, n5);
            n6 += n5;
        }
        return n4;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2;
        int n2;
        if (!this.buffer.hasRemaining() && this.fill() < 0) {
            return 0L;
        }
        for (l2 = 0L; l2 < l && (this.buffer.hasRemaining() || this.fill() >= 0); l2 += (long)n2) {
            n2 = (int)Math.min(l - l2, (long)this.buffer.remaining());
            this.buffer.position(this.buffer.position() + n2);
        }
        return l2;
    }

    private int fill() throws IOException {
        this.buffer.clear();
        int n2 = this.decoder.decode(this.in, this.buffer);
        if (n2 > this.buffer.capacity()) {
            throw new AssertionError((Object)String.format("Decode beyond buffer (%d): %d (using %s decoder)", this.buffer.capacity(), n2, this.decoder.getClass().getName()));
        }
        this.buffer.flip();
        if (n2 == 0) {
            return -1;
        }
        return n2;
    }
}

