/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.eval.env;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.eval.CastResult;
import at.petrak.hexcasting.api.casting.eval.ExecutionClientView;
import at.petrak.hexcasting.api.casting.eval.ResolvedPattern;
import at.petrak.hexcasting.api.casting.eval.env.PlayerBasedCastEnv;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.casting.math.HexCoord;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.mod.HexStatistics;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.common.msgs.IMessage;
import at.petrak.hexcasting.common.msgs.MsgClearSpiralPatternsS2C;
import at.petrak.hexcasting.common.msgs.MsgNewSpellPatternC2S;
import at.petrak.hexcasting.common.msgs.MsgNewSpellPatternS2C;
import at.petrak.hexcasting.common.msgs.MsgNewSpiralPatternsS2C;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class StaffCastEnv
extends PlayerBasedCastEnv {
    private final class_1268 castingHand;
    private final Set<HexPattern> castPatterns = new HashSet<HexPattern>();
    private int soundsPlayed = 0;

    public StaffCastEnv(class_3222 caster, class_1268 castingHand) {
        super(caster, castingHand);
        this.castingHand = castingHand;
    }

    @Override
    public void postExecution(CastResult result) {
        super.postExecution(result);
        Iota iota = result.component1();
        if (iota instanceof PatternIota) {
            PatternIota patternIota = (PatternIota)iota;
            this.castPatterns.add(patternIota.getPattern());
        }
        class_3414 sound = result.getSound().sound();
        if (this.soundsPlayed < 100 && sound != null) {
            class_243 soundPos = this.caster.method_19538();
            this.world.method_43128(null, soundPos.field_1352, soundPos.field_1351, soundPos.field_1350, sound, class_3419.field_15248, 1.0f, 1.0f);
            ++this.soundsPlayed;
        }
    }

    @Override
    public void postCast(CastingImage image) {
        super.postCast(image);
        MsgNewSpiralPatternsS2C packet = new MsgNewSpiralPatternsS2C(this.caster.method_5667(), this.castPatterns.stream().toList(), Integer.MAX_VALUE);
        IXplatAbstractions.INSTANCE.sendPacketToPlayer(this.caster, packet);
        IXplatAbstractions.INSTANCE.sendPacketTracking((class_1297)this.caster, packet);
        this.castPatterns.clear();
        this.soundsPlayed = 0;
    }

    @Override
    public long extractMediaEnvironment(long cost, boolean simulate) {
        if (this.caster.method_7337()) {
            return 0L;
        }
        boolean canOvercast = this.canOvercast();
        return this.extractMediaFromInventory(cost, canOvercast, simulate);
    }

    @Override
    public class_1268 getCastingHand() {
        return this.castingHand;
    }

    @Override
    public FrozenPigment getPigment() {
        return HexAPI.instance().getColorizer((class_1657)this.caster);
    }

    public static void handleNewPatternOnServer(class_3222 sender, MsgNewSpellPatternC2S msg) {
        boolean cheatedPatternOverlap = false;
        List<ResolvedPattern> resolvedPatterns = msg.resolvedPatterns();
        if (!resolvedPatterns.isEmpty()) {
            HashSet<HexCoord> allPoints = new HashSet<HexCoord>();
            for (int i = 0; i < resolvedPatterns.size() - 1; ++i) {
                ResolvedPattern pat = resolvedPatterns.get(i);
                allPoints.addAll(pat.getPattern().positions(pat.getOrigin()));
            }
            ResolvedPattern currentResolvedPattern = resolvedPatterns.get(resolvedPatterns.size() - 1);
            List<HexCoord> currentSpellPoints = currentResolvedPattern.getPattern().positions(currentResolvedPattern.getOrigin());
            if (currentSpellPoints.stream().anyMatch(allPoints::contains)) {
                cheatedPatternOverlap = true;
            }
        }
        if (cheatedPatternOverlap) {
            return;
        }
        sender.method_7281(HexStatistics.PATTERNS_DRAWN);
        CastingVM vm = IXplatAbstractions.INSTANCE.getStaffcastVM(sender, msg.handUsed());
        ExecutionClientView clientInfo = vm.queueExecuteAndWrapIota(new PatternIota(msg.pattern()), sender.method_51469());
        if (clientInfo.isStackClear()) {
            IXplatAbstractions.INSTANCE.setStaffcastImage(sender, null);
            IXplatAbstractions.INSTANCE.setPatterns(sender, List.of());
        } else {
            IXplatAbstractions.INSTANCE.setStaffcastImage(sender, vm.getImage().withOverriddenUsedOps(0L));
            if (!resolvedPatterns.isEmpty()) {
                resolvedPatterns.get(resolvedPatterns.size() - 1).setType(clientInfo.getResolutionType());
            }
            IXplatAbstractions.INSTANCE.setPatterns(sender, resolvedPatterns);
        }
        IXplatAbstractions.INSTANCE.sendPacketToPlayer(sender, new MsgNewSpellPatternS2C(clientInfo, resolvedPatterns.size() - 1));
        Record packet = clientInfo.isStackClear() ? new MsgClearSpiralPatternsS2C(sender.method_5667()) : new MsgNewSpiralPatternsS2C(sender.method_5667(), List.of(msg.pattern()), Integer.MAX_VALUE);
        IXplatAbstractions.INSTANCE.sendPacketToPlayer(sender, (IMessage)((Object)packet));
        IXplatAbstractions.INSTANCE.sendPacketTracking((class_1297)sender, (IMessage)((Object)packet));
        if (clientInfo.getResolutionType().getSuccess()) {
            new ParticleSpray(sender.method_19538(), new class_243(0.0, 1.5, 0.0), 0.4, 1.0471975511965976, 30).sprayParticles(sender.method_51469(), IXplatAbstractions.INSTANCE.getPigment((class_1657)sender));
        }
    }
}

