/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.iota;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import net.minecraft.class_124;
import net.minecraft.class_2489;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleIota
extends Iota {
    public static final double TOLERANCE = 1.0E-4;
    public static IotaType<DoubleIota> TYPE = new IotaType<DoubleIota>(){

        @Override
        @Nullable
        public DoubleIota deserialize(class_2520 tag, class_3218 world) throws IllegalArgumentException {
            return DoubleIota.deserialize(tag);
        }

        @Override
        public class_2561 display(class_2520 tag) {
            return DoubleIota.display(DoubleIota.deserialize(tag).getDouble());
        }

        @Override
        public int color() {
            return -11141291;
        }
    };

    public DoubleIota(double d) {
        super(HexIotaTypes.DOUBLE, d);
    }

    public double getDouble() {
        return HexUtils.fixNAN((Double)this.payload);
    }

    @Override
    public boolean isTruthy() {
        return this.getDouble() != 0.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean toleratesOther(Iota that) {
        if (!DoubleIota.typesMatch(this, that)) return false;
        if (!(that instanceof DoubleIota)) return false;
        DoubleIota dd = (DoubleIota)that;
        if (!DoubleIota.tolerates(this.getDouble(), dd.getDouble())) return false;
        return true;
    }

    public static boolean tolerates(double a, double b) {
        return Math.abs(a - b) < 1.0E-4;
    }

    @Override
    @NotNull
    public class_2520 serialize() {
        return class_2489.method_23241((double)this.getDouble());
    }

    public static DoubleIota deserialize(class_2520 tag) throws IllegalArgumentException {
        class_2489 dtag = (class_2489)HexUtils.downcast(tag, class_2489.field_21031);
        return new DoubleIota(dtag.method_10697());
    }

    public static class_2561 display(double d) {
        return class_2561.method_43470((String)String.format("%.2f", d)).method_27692(class_124.field_1060);
    }
}

