/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.iota;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.PatternShapeMatch;
import at.petrak.hexcasting.api.casting.castables.Action;
import at.petrak.hexcasting.api.casting.eval.CastResult;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.ResolvedPatternType;
import at.petrak.hexcasting.api.casting.eval.sideeffects.OperatorSideEffect;
import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.casting.mishaps.MishapEvalTooMuch;
import at.petrak.hexcasting.api.casting.mishaps.MishapInvalidPattern;
import at.petrak.hexcasting.api.casting.mishaps.MishapUnenlightened;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.casting.PatternRegistryManifest;
import at.petrak.hexcasting.common.lib.hex.HexEvalSounds;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import at.petrak.hexcasting.interop.inline.InlinePatternData;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternIota
extends Iota {
    public static IotaType<PatternIota> TYPE = new IotaType<PatternIota>(){

        @Override
        public PatternIota deserialize(class_2520 tag, class_3218 world) throws IllegalArgumentException {
            return PatternIota.deserialize(tag);
        }

        @Override
        public class_2561 display(class_2520 tag) {
            return PatternIota.display(PatternIota.deserialize(tag).getPattern());
        }

        @Override
        public int color() {
            return -22016;
        }
    };

    public PatternIota(@NotNull HexPattern pattern) {
        super(HexIotaTypes.PATTERN, pattern);
    }

    public HexPattern getPattern() {
        return (HexPattern)this.payload;
    }

    protected PatternIota(@NotNull IotaType<?> type, @NotNull Object payload) {
        super(type, payload);
    }

    @Override
    public boolean isTruthy() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean toleratesOther(Iota that) {
        if (!PatternIota.typesMatch(this, that)) return false;
        if (!(that instanceof PatternIota)) return false;
        PatternIota piota = (PatternIota)that;
        if (!this.getPattern().getAngles().equals(piota.getPattern().getAngles())) return false;
        return true;
    }

    @Override
    @NotNull
    public class_2520 serialize() {
        return this.getPattern().serializeToNBT();
    }

    @Override
    @NotNull
    public CastResult execute(CastingVM vm, class_3218 world, SpellContinuation continuation) {
        Supplier<@Nullable class_2561> castedName = () -> null;
        try {
            Action action;
            PatternShapeMatch lookup = PatternRegistryManifest.matchPattern(this.getPattern(), vm.getEnv(), false);
            vm.getEnv().precheckAction(lookup);
            if (lookup instanceof PatternShapeMatch.Normal || lookup instanceof PatternShapeMatch.PerWorld) {
                class_5321<ActionRegistryEntry> key;
                if (lookup instanceof PatternShapeMatch.Normal) {
                    PatternShapeMatch.Normal normal = (PatternShapeMatch.Normal)lookup;
                    key = normal.key;
                } else {
                    PatternShapeMatch.PerWorld perWorld = (PatternShapeMatch.PerWorld)lookup;
                    key = perWorld.key;
                }
                boolean reqsEnlightenment = HexUtils.isOfTag(IXplatAbstractions.INSTANCE.getActionRegistry(), key, HexTags.Actions.REQUIRES_ENLIGHTENMENT);
                castedName = () -> HexAPI.instance().getActionI18n(key, reqsEnlightenment);
                action = Objects.requireNonNull((ActionRegistryEntry)IXplatAbstractions.INSTANCE.getActionRegistry().method_29107(key)).action();
                if (reqsEnlightenment && !vm.getEnv().isEnlightened()) {
                    throw new MishapUnenlightened();
                }
            } else if (lookup instanceof PatternShapeMatch.Special) {
                PatternShapeMatch.Special special = (PatternShapeMatch.Special)lookup;
                castedName = special.handler::getName;
                action = special.handler.act();
            } else {
                if (lookup instanceof PatternShapeMatch.Nothing) {
                    throw new MishapInvalidPattern(this.getPattern());
                }
                throw new IllegalStateException();
            }
            OperationResult result = action.operate(vm.getEnv(), vm.getImage(), continuation);
            if (result.getNewImage().getOpsConsumed() > (long)vm.getEnv().maxOpCount()) {
                throw new MishapEvalTooMuch();
            }
            SpellContinuation cont2 = result.getNewContinuation();
            List<OperatorSideEffect> sideEffects = result.getSideEffects();
            return new CastResult(this, cont2, result.getNewImage(), sideEffects, ResolvedPatternType.EVALUATED, result.getSound());
        }
        catch (Mishap mishap) {
            return new CastResult(this, continuation, null, List.of(new OperatorSideEffect.DoMishap(mishap, new Mishap.Context(this.getPattern(), castedName.get()))), mishap.resolutionType(vm.getEnv()), HexEvalSounds.MISHAP);
        }
    }

    @Override
    public boolean executable() {
        return true;
    }

    public static PatternIota deserialize(class_2520 tag) throws IllegalArgumentException {
        class_2487 patTag = (class_2487)HexUtils.downcast(tag, class_2487.field_21029);
        HexPattern pat = HexPattern.fromNBT(patTag);
        return new PatternIota(pat);
    }

    public static class_2561 display(HexPattern pat) {
        class_2561 text = new InlinePatternData(pat).asText(true);
        return text.method_27661().method_27696(text.method_10866().method_27702(class_2583.field_24360.method_10977(class_124.field_1068)));
    }

    public static class_2561 displayNonInline(HexPattern pat) {
        StringBuilder bob = new StringBuilder();
        bob.append((Object)pat.getStartDir());
        String sig = pat.anglesSignature();
        if (!sig.isEmpty()) {
            bob.append(" ");
            bob.append(sig);
        }
        return class_2561.method_43469((String)"hexcasting.tooltip.pattern_iota", (Object[])new Object[]{class_2561.method_43470((String)bob.toString()).method_27692(class_124.field_1068)}).method_27692(class_124.field_1065);
    }
}

