/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.client;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public final class ScryingLensOverlayRegistry {
    private static final ConcurrentMap<class_2960, OverlayBuilder> ID_LOOKUP = new ConcurrentHashMap<class_2960, OverlayBuilder>();
    private static final List<Pair<OverlayPredicate, OverlayBuilder>> PREDICATE_LOOKUP = new Vector<Pair<OverlayPredicate, OverlayBuilder>>();

    public static void addDisplayer(class_2248 block, OverlayBuilder displayer) {
        ScryingLensOverlayRegistry.addDisplayer(class_7923.field_41175.method_10221((Object)block), displayer);
    }

    public static void addDisplayer(class_2960 blockID, OverlayBuilder displayer) {
        if (ID_LOOKUP.containsKey(blockID)) {
            throw new IllegalArgumentException("Already have a displayer for " + blockID);
        }
        ID_LOOKUP.put(blockID, displayer);
    }

    public static void addPredicateDisplayer(OverlayPredicate predicate, OverlayBuilder displayer) {
        PREDICATE_LOOKUP.add((Pair<OverlayPredicate, OverlayBuilder>)new Pair((Object)predicate, (Object)displayer));
    }

    @NotNull
    public static List<Pair<class_1799, class_2561>> getLines(class_2680 state, class_2338 pos, class_1657 observer, class_1937 world, class_2350 hitFace) {
        ArrayList lines = Lists.newArrayList();
        OverlayBuilder idLookedup = (OverlayBuilder)ID_LOOKUP.get(class_7923.field_41175.method_10221((Object)state.method_26204()));
        if (idLookedup != null) {
            idLookedup.addLines(lines, state, pos, observer, world, hitFace);
        }
        for (Pair<OverlayPredicate, OverlayBuilder> pair : PREDICATE_LOOKUP) {
            if (!((OverlayPredicate)pair.getFirst()).test(state, pos, observer, world, hitFace)) continue;
            ((OverlayBuilder)pair.getSecond()).addLines(lines, state, pos, observer, world, hitFace);
        }
        return lines;
    }

    @FunctionalInterface
    public static interface OverlayBuilder {
        public void addLines(List<Pair<class_1799, class_2561>> var1, class_2680 var2, class_2338 var3, class_1657 var4, class_1937 var5, class_2350 var6);
    }

    @FunctionalInterface
    public static interface OverlayPredicate {
        public boolean test(class_2680 var1, class_2338 var2, class_1657 var3, class_1937 var4, class_2350 var5);
    }
}

