/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.entity;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import at.petrak.hexcasting.api.pigment.ColorProvider;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.common.blocks.BlockConjured;
import at.petrak.hexcasting.common.blocks.BlockConjuredLight;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import at.petrak.hexcasting.common.particles.ConjureParticleOptions;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;

public class BlockEntityConjured
extends HexBlockEntity {
    private static final Random RANDOM = new Random();
    private FrozenPigment colorizer = FrozenPigment.DEFAULT.get();
    public static final String TAG_COLORIZER = "tag_colorizer";

    public BlockEntityConjured(class_2338 pos, class_2680 state) {
        super(HexBlockEntities.CONJURED_TILE, pos, state);
    }

    public void walkParticle(class_1297 pEntity) {
        BlockConjured conjured;
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof BlockConjured && !((conjured = (BlockConjured)class_22482) instanceof BlockConjuredLight)) {
            ColorProvider colProvider = this.colorizer.getColorProvider();
            for (int i = 0; i < 3; ++i) {
                int color = colProvider.getColor(pEntity.field_6012, pEntity.method_19538().method_1019(new class_243((double)RANDOM.nextFloat(), (double)RANDOM.nextFloat(), (double)RANDOM.nextFloat()).method_1021((double)(RANDOM.nextFloat() * 3.0f))));
                assert (this.field_11863 != null);
                this.field_11863.method_8406((class_2394)new ConjureParticleOptions(color), pEntity.method_23317() + (double)RANDOM.nextFloat() * 0.6 - 0.3, (double)this.method_11016().method_10264() + (double)RANDOM.nextFloat() * 0.05 + 0.95, pEntity.method_23321() + (double)RANDOM.nextFloat() * 0.6 - 0.3, (double)RANDOM.nextFloat(-0.02f, 0.02f), (double)RANDOM.nextFloat(0.02f), (double)RANDOM.nextFloat(-0.02f, 0.02f));
            }
        }
    }

    public void particleEffect() {
        if (this.method_11010().method_26204() instanceof BlockConjured) {
            int color = this.colorizer.getColorProvider().getColor(RANDOM.nextFloat() * 16384.0f, new class_243((double)RANDOM.nextFloat(), (double)RANDOM.nextFloat(), (double)RANDOM.nextFloat()).method_1021((double)(RANDOM.nextFloat() * 3.0f)));
            assert (this.field_11863 != null);
            if (this.method_11010().method_26204() instanceof BlockConjuredLight) {
                if ((double)RANDOM.nextFloat() < 0.5) {
                    this.field_11863.method_8406((class_2394)new ConjureParticleOptions(color), (double)this.method_11016().method_10263() + 0.45 + (double)RANDOM.nextFloat() * 0.1, (double)this.method_11016().method_10264() + 0.45 + (double)RANDOM.nextFloat() * 0.1, (double)this.method_11016().method_10260() + 0.45 + (double)RANDOM.nextFloat() * 0.1, (double)RANDOM.nextFloat(-0.005f, 0.005f), (double)RANDOM.nextFloat(-0.002f, 0.02f), (double)RANDOM.nextFloat(-0.005f, 0.005f));
                }
            } else if ((double)RANDOM.nextFloat() < 0.2) {
                this.field_11863.method_8406((class_2394)new ConjureParticleOptions(color), (double)this.method_11016().method_10263() + (double)RANDOM.nextFloat(), (double)this.method_11016().method_10264() + (double)RANDOM.nextFloat(), (double)this.method_11016().method_10260() + (double)RANDOM.nextFloat(), (double)RANDOM.nextFloat(-0.02f, 0.02f), (double)RANDOM.nextFloat(-0.02f, 0.02f), (double)RANDOM.nextFloat(-0.02f, 0.02f));
            }
        }
    }

    public void landParticle(class_1297 entity, int number) {
        ColorProvider colProvider = this.colorizer.getColorProvider();
        for (int i = 0; i < number * 2; ++i) {
            int color = colProvider.getColor(entity.field_6012, entity.method_19538().method_1019(new class_243((double)RANDOM.nextFloat(), (double)RANDOM.nextFloat(), (double)RANDOM.nextFloat()).method_1021((double)(RANDOM.nextFloat() * 3.0f))));
            assert (this.field_11863 != null);
            this.field_11863.method_8406((class_2394)new ConjureParticleOptions(color), entity.method_23317() + (double)RANDOM.nextFloat() * 0.8 - 0.2, (double)this.method_11016().method_10264() + (double)RANDOM.nextFloat() * 0.05 + 0.95, entity.method_23321() + (double)RANDOM.nextFloat() * 0.8 - 0.2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void saveModData(class_2487 tag) {
        tag.method_10566(TAG_COLORIZER, (class_2520)this.colorizer.serializeToNBT());
    }

    @Override
    protected void loadModData(class_2487 tag) {
        this.colorizer = FrozenPigment.fromNBT(tag.method_10562(TAG_COLORIZER));
    }

    public FrozenPigment getColorizer() {
        return this.colorizer;
    }

    public void setColorizer(FrozenPigment colorizer) {
        this.colorizer = colorizer;
        this.sync();
    }
}

