/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.PatternShapeMatch;
import at.petrak.hexcasting.api.casting.castables.SpecialHandler;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.math.HexAngle;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.server.ScrungledPatternsSave;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_2378;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;

public class PatternRegistryManifest {
    private static final ConcurrentMap<List<HexAngle>, class_5321<ActionRegistryEntry>> NORMAL_ACTION_LOOKUP = new ConcurrentHashMap<List<HexAngle>, class_5321<ActionRegistryEntry>>();

    public static void processRegistry(@Nullable class_3218 overworld) {
        int perWorldActionCount = 0;
        class_2378<ActionRegistryEntry> registry = IXplatAbstractions.INSTANCE.getActionRegistry();
        for (class_5321 key : registry.method_42021()) {
            ActionRegistryEntry entry = (ActionRegistryEntry)registry.method_29107(key);
            if (entry == null) continue;
            if (!HexUtils.isOfTag(registry, key, HexTags.Actions.PER_WORLD_PATTERN)) {
                class_5321<ActionRegistryEntry> old = NORMAL_ACTION_LOOKUP.put(entry.prototype().getAngles(), (class_5321<ActionRegistryEntry>)key);
                if (old == null) continue;
                HexAPI.LOGGER.warn("Inserted %s which has same signature as %s, overriding it.".formatted(key, old));
                continue;
            }
            ++perWorldActionCount;
        }
        HexAPI.LOGGER.info("We're on the %s! Loaded %d regular actions, %d per-world actions, and %d special handlers".formatted(overworld == null ? "client" : "server", NORMAL_ACTION_LOOKUP.size(), perWorldActionCount, IXplatAbstractions.INSTANCE.getSpecialHandlerRegistry().method_10204()));
    }

    @Nullable
    public static Pair<SpecialHandler, class_5321<SpecialHandler.Factory<?>>> matchPatternToSpecialHandler(HexPattern pat, CastingEnvironment environment) {
        class_2378<SpecialHandler.Factory<?>> registry = IXplatAbstractions.INSTANCE.getSpecialHandlerRegistry();
        for (class_5321 key : registry.method_42021()) {
            Object handler;
            SpecialHandler.Factory factory = (SpecialHandler.Factory)registry.method_29107(key);
            if (factory == null || (handler = factory.tryMatch(pat, environment)) == null) continue;
            return Pair.of(handler, (Object)key);
        }
        return null;
    }

    public static PatternShapeMatch matchPattern(HexPattern pat, CastingEnvironment environment, boolean checkForAlternateStrokeOrders) {
        List<HexAngle> sig = pat.getAngles();
        if (NORMAL_ACTION_LOOKUP.containsKey(sig)) {
            class_5321 key = (class_5321)NORMAL_ACTION_LOOKUP.get(sig);
            return new PatternShapeMatch.Normal((class_5321<ActionRegistryEntry>)key);
        }
        ScrungledPatternsSave perWorldPatterns = ScrungledPatternsSave.open(environment.getWorld().method_8503().method_30002());
        ScrungledPatternsSave.PerWorldEntry entry = perWorldPatterns.lookup(pat.anglesSignature());
        if (entry != null) {
            return new PatternShapeMatch.PerWorld(entry.key(), true);
        }
        if (checkForAlternateStrokeOrders) {
            throw new NotImplementedException("checking for alternate stroke orders is NYI sorry");
        }
        Pair<SpecialHandler, class_5321<SpecialHandler.Factory<?>>> shMatch = PatternRegistryManifest.matchPatternToSpecialHandler(pat, environment);
        if (shMatch != null) {
            return new PatternShapeMatch.Special((class_5321)shMatch.getSecond(), (SpecialHandler)shMatch.getFirst());
        }
        return new PatternShapeMatch.Nothing();
    }

    @Nullable
    public static HexPattern getCanonicalStrokesPerWorld(class_5321<ActionRegistryEntry> key, class_3218 overworld) {
        ScrungledPatternsSave perWorldPatterns = ScrungledPatternsSave.open(overworld);
        Pair<String, ScrungledPatternsSave.PerWorldEntry> pair = perWorldPatterns.lookupReverse(key);
        if (pair == null) {
            return null;
        }
        String sig = (String)pair.getFirst();
        ScrungledPatternsSave.PerWorldEntry entry = (ScrungledPatternsSave.PerWorldEntry)pair.getSecond();
        return HexPattern.fromAnglesUnchecked(sig, entry.canonicalStartDir());
    }
}

