/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.lib.hex;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.eval.sideeffects.EvalSound;
import at.petrak.hexcasting.common.lib.HexSounds;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_2960;

public class HexEvalSounds {
    private static final Map<class_2960, EvalSound> SOUNDS = new LinkedHashMap<class_2960, EvalSound>();
    public static final EvalSound NOTHING = HexEvalSounds.make("nothing", new EvalSound(null, Integer.MIN_VALUE));
    public static final EvalSound NORMAL_EXECUTE = HexEvalSounds.make("operator", new EvalSound(HexSounds.CAST_NORMAL, 0));
    public static final EvalSound SPELL = HexEvalSounds.make("spell", new EvalSound(HexSounds.CAST_SPELL, 1000));
    public static final EvalSound HERMES = HexEvalSounds.make("hermes", new EvalSound(HexSounds.CAST_HERMES, 2000));
    public static final EvalSound THOTH = HexEvalSounds.make("thoth", new EvalSound(HexSounds.CAST_THOTH, 2500));
    public static final EvalSound MUTE = HexEvalSounds.make("mute", new EvalSound(null, 3000));
    public static final EvalSound MISHAP = HexEvalSounds.make("mishap", new EvalSound(HexSounds.CAST_FAILURE, 4000));

    private static EvalSound make(String name, EvalSound sound) {
        EvalSound old = SOUNDS.put(HexAPI.modLoc(name), sound);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + name);
        }
        return sound;
    }

    public static void register(BiConsumer<EvalSound, class_2960> r) {
        for (Map.Entry<class_2960, EvalSound> e : SOUNDS.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }
}

