/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.msgs;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.storage.ItemSpellbook;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.common.msgs.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public record MsgShiftScrollC2S(double mainHandDelta, double offHandDelta, boolean isCtrl, boolean invertSpellbook, boolean invertAbacus) implements IMessage
{
    public static final class_2960 ID = HexAPI.modLoc("scroll");

    @Override
    public class_2960 getFabricId() {
        return ID;
    }

    public static MsgShiftScrollC2S deserialize(ByteBuf buffer) {
        class_2540 buf = new class_2540(buffer);
        double mainHandDelta = buf.readDouble();
        double offHandDelta = buf.readDouble();
        boolean isCtrl = buf.readBoolean();
        boolean invertSpellbook = buf.readBoolean();
        boolean invertAbacus = buf.readBoolean();
        return new MsgShiftScrollC2S(mainHandDelta, offHandDelta, isCtrl, invertSpellbook, invertAbacus);
    }

    @Override
    public void serialize(class_2540 buf) {
        buf.writeDouble(this.mainHandDelta);
        buf.writeDouble(this.offHandDelta);
        buf.writeBoolean(this.isCtrl);
        buf.writeBoolean(this.invertSpellbook);
        buf.writeBoolean(this.invertAbacus);
    }

    public void handle(MinecraftServer server, class_3222 sender) {
        server.execute(() -> {
            this.handleForHand(sender, class_1268.field_5808, this.mainHandDelta);
            this.handleForHand(sender, class_1268.field_5810, this.offHandDelta);
        });
    }

    private void handleForHand(class_3222 sender, class_1268 hand, double delta) {
        if (delta != 0.0) {
            class_1799 stack = sender.method_5998(hand);
            if (stack.method_7909() == HexItems.SPELLBOOK) {
                this.spellbook(sender, hand, stack, delta);
            } else if (stack.method_7909() == HexItems.ABACUS) {
                this.abacus(sender, hand, stack, delta);
            }
        }
    }

    private void spellbook(class_3222 sender, class_1268 hand, class_1799 stack, double delta) {
        if (this.invertSpellbook) {
            delta = -delta;
        }
        int newIdx = ItemSpellbook.rotatePageIdx(stack, delta < 0.0);
        int len = ItemSpellbook.highestPage(stack);
        boolean sealed = ItemSpellbook.isSealed(stack);
        class_5250 component = hand == class_1268.field_5810 && stack.method_7938() ? (sealed ? class_2561.method_43469((String)"hexcasting.tooltip.spellbook.page_with_name.sealed", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(newIdx)).method_27692(class_124.field_1068), class_2561.method_43470((String)String.valueOf(len)).method_27692(class_124.field_1068), class_2561.method_43470((String)"").method_27695(new class_124[]{stack.method_7932().field_8908, class_124.field_1056}).method_10852(stack.method_7964()), class_2561.method_43471((String)"hexcasting.tooltip.spellbook.sealed").method_27692(class_124.field_1065)}) : class_2561.method_43469((String)"hexcasting.tooltip.spellbook.page_with_name", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(newIdx)).method_27692(class_124.field_1068), class_2561.method_43470((String)String.valueOf(len)).method_27692(class_124.field_1068), class_2561.method_43470((String)"").method_27695(new class_124[]{stack.method_7932().field_8908, class_124.field_1056}).method_10852(stack.method_7964())})) : (sealed ? class_2561.method_43469((String)"hexcasting.tooltip.spellbook.page.sealed", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(newIdx)).method_27692(class_124.field_1068), class_2561.method_43470((String)String.valueOf(len)).method_27692(class_124.field_1068), class_2561.method_43471((String)"hexcasting.tooltip.spellbook.sealed").method_27692(class_124.field_1065)}) : class_2561.method_43469((String)"hexcasting.tooltip.spellbook.page", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(newIdx)).method_27692(class_124.field_1068), class_2561.method_43470((String)String.valueOf(len)).method_27692(class_124.field_1068)}));
        sender.method_7353((class_2561)component.method_27692(class_124.field_1080), true);
    }

    private void abacus(class_3222 sender, class_1268 hand, class_1799 stack, double delta) {
        float pitch;
        double shiftDelta;
        if (this.invertAbacus) {
            delta = -delta;
        }
        boolean increase = delta < 0.0;
        double num = NBTHelper.getDouble(stack, "value");
        if (hand == class_1268.field_5808) {
            shiftDelta = this.isCtrl ? 10.0 : 1.0;
            pitch = this.isCtrl ? 0.7f : 0.9f;
        } else {
            shiftDelta = this.isCtrl ? 0.01 : 0.1;
            pitch = this.isCtrl ? 1.3f : 1.0f;
        }
        int scale = Math.max((int)Math.floor(Math.abs(delta)), 1);
        NBTHelper.putDouble(stack, "value", num += (double)scale * shiftDelta * (double)(increase ? 1 : -1));
        pitch *= increase ? 1.05f : 0.95f;
        pitch = (float)((double)pitch + (Math.random() - 0.5) * 0.1);
        sender.method_37908().method_43128(null, sender.method_23317(), sender.method_23318(), sender.method_23321(), HexSounds.ABACUS, class_3419.field_15248, 0.5f, pitch);
        class_2487 datumTag = HexItems.ABACUS.readIotaTag(stack);
        if (datumTag != null) {
            class_2561 popup = IotaType.getDisplay(datumTag);
            sender.method_7353((class_2561)class_2561.method_43469((String)"hexcasting.tooltip.abacus", (Object[])new Object[]{popup}).method_27692(class_124.field_1060), true);
        }
    }
}

