/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.recipe;

import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.common.items.storage.ItemFocus;
import at.petrak.hexcasting.common.items.storage.ItemSpellbook;
import at.petrak.hexcasting.common.lib.HexItems;
import java.util.Locale;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;

public class SealThingsRecipe
extends class_1852 {
    public final Sealee sealee;
    public static final class_1866<SealThingsRecipe> FOCUS_SERIALIZER = new class_1866(SealThingsRecipe::focus);
    public static final class_1866<SealThingsRecipe> SPELLBOOK_SERIALIZER = new class_1866(SealThingsRecipe::spellbook);

    public SealThingsRecipe(class_2960 id, class_7710 category, Sealee sealee) {
        super(id, category);
        this.sealee = sealee;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    public boolean matches(class_8566 container, class_1937 level) {
        boolean foundComb = false;
        boolean foundSealee = false;
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 stack = container.method_5438(i);
            if (this.sealee.isCorrectSealee(stack)) {
                if (foundSealee) {
                    return false;
                }
                foundSealee = true;
                continue;
            }
            if (!stack.method_31573(HexTags.Items.SEAL_MATERIALS)) continue;
            if (foundComb) {
                return false;
            }
            foundComb = true;
        }
        return foundComb && foundSealee;
    }

    public class_1799 assemble(class_8566 inv, class_5455 registryAccess) {
        class_1799 sealee = class_1799.field_8037;
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (!this.sealee.isCorrectSealee(stack)) continue;
            sealee = stack.method_7972();
            break;
        }
        if (!sealee.method_7960()) {
            this.sealee.seal(sealee);
            sealee.method_7939(1);
        }
        return sealee;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return switch (this.sealee) {
            default -> throw new IncompatibleClassChangeError();
            case Sealee.FOCUS -> FOCUS_SERIALIZER;
            case Sealee.SPELLBOOK -> SPELLBOOK_SERIALIZER;
        };
    }

    public static SealThingsRecipe focus(class_2960 id, class_7710 category) {
        return new SealThingsRecipe(id, category, Sealee.FOCUS);
    }

    public static SealThingsRecipe spellbook(class_2960 id, class_7710 category) {
        return new SealThingsRecipe(id, category, Sealee.SPELLBOOK);
    }

    public static enum Sealee implements class_3542
    {
        FOCUS,
        SPELLBOOK;


        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean isCorrectSealee(class_1799 stack) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case FOCUS -> {
                    if (stack.method_31574((class_1792)HexItems.FOCUS) && HexItems.FOCUS.readIotaTag(stack) != null && !ItemFocus.isSealed(stack)) {
                        yield true;
                    }
                    yield false;
                }
                case SPELLBOOK -> stack.method_31574((class_1792)HexItems.SPELLBOOK) && HexItems.SPELLBOOK.readIotaTag(stack) != null && !ItemSpellbook.isSealed(stack);
            };
        }

        public void seal(class_1799 stack) {
            switch (this) {
                case FOCUS: {
                    ItemFocus.seal(stack);
                    break;
                }
                case SPELLBOOK: {
                    ItemSpellbook.setSealed(stack, true);
                }
            }
        }
    }
}

