/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.recipe.ingredient;

import at.petrak.hexcasting.common.recipe.ingredient.StateIngredient;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_7923;

public class StateIngredientBlocks
implements StateIngredient {
    protected final ImmutableSet<class_2248> blocks;

    public StateIngredientBlocks(Collection<class_2248> blocks) {
        this.blocks = ImmutableSet.copyOf(blocks);
    }

    @Override
    public boolean test(class_2680 state) {
        return this.blocks.contains((Object)state.method_26204());
    }

    @Override
    public class_2680 pick(Random random) {
        return ((class_2248)this.blocks.asList().get(random.nextInt(this.blocks.size()))).method_9564();
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "blocks");
        JsonArray array = new JsonArray();
        for (class_2248 block : this.blocks) {
            array.add(class_7923.field_41175.method_10221((Object)block).toString());
        }
        object.add("blocks", (JsonElement)array);
        return object;
    }

    @Override
    public void write(class_2540 buffer) {
        List<class_2248> blocks = this.getBlocks();
        buffer.method_10804(0);
        buffer.method_10804(blocks.size());
        for (class_2248 block : blocks) {
            buffer.method_10804(class_7923.field_41175.method_10206((Object)block));
        }
    }

    @Override
    public List<class_1799> getDisplayedStacks() {
        return this.blocks.stream().filter(b -> b.method_8389() != class_1802.field_8162).map(class_1799::new).collect(Collectors.toList());
    }

    @Override
    public List<class_2680> getDisplayed() {
        return this.blocks.stream().map(class_2248::method_9564).collect(Collectors.toList());
    }

    @Nonnull
    protected List<class_2248> getBlocks() {
        return this.blocks.asList();
    }

    public String toString() {
        return "StateIngredientBlocks{" + this.blocks.toString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.blocks.equals(((StateIngredientBlocks)o).blocks);
    }

    public int hashCode() {
        return Objects.hash(this.blocks);
    }
}

