/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.fabric;

import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.common.loot.HexLootHandler;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5321;

@Config(name="hexcasting")
@Config.Gui.Background(value="minecraft:textures/block/calcite.png")
public class FabricHexConfig
extends PartitioningSerializer.GlobalData {
    @ConfigEntry.Category(value="common")
    @ConfigEntry.Gui.TransitiveObject
    public final Common common = new Common();
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.TransitiveObject
    public final Client client = new Client();
    @ConfigEntry.Category(value="server")
    @ConfigEntry.Gui.TransitiveObject
    public final Server server = new Server();

    public static FabricHexConfig setup() {
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).create();
        AutoConfig.register(FabricHexConfig.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap((cfg, clazz) -> new GsonConfigSerializer(cfg, clazz, gson)));
        FabricHexConfig instance = (FabricHexConfig)AutoConfig.getConfigHolder(FabricHexConfig.class).getConfig();
        HexConfig.setCommon(instance.common);
        if (IXplatAbstractions.INSTANCE.isPhysicalClient()) {
            HexConfig.setClient(instance.client);
        }
        HexConfig.setServer(instance.server);
        return instance;
    }

    @Config(name="common")
    public static final class Common
    implements HexConfig.CommonConfigAccess,
    ConfigData {
        @ConfigEntry.Gui.Tooltip
        private long dustMediaAmount = 10000L;
        @ConfigEntry.Gui.Tooltip
        private long shardMediaAmount = 50000L;
        @ConfigEntry.Gui.Tooltip
        private long chargedCrystalMediaAmount = 100000L;
        @ConfigEntry.Gui.Tooltip
        private double mediaToHealthRate = 10000.0;
        @ConfigEntry.Gui.Tooltip
        private int cypherCooldown = 8;
        @ConfigEntry.Gui.Tooltip
        private int trinketCooldown = 5;
        @ConfigEntry.Gui.Tooltip
        private int artifactCooldown = 3;

        public void validatePostLoad() throws ConfigData.ValidationException {
            this.dustMediaAmount = Math.max(this.dustMediaAmount, 0L);
            this.shardMediaAmount = Math.max(this.shardMediaAmount, 0L);
            this.chargedCrystalMediaAmount = Math.max(this.chargedCrystalMediaAmount, 0L);
            this.mediaToHealthRate = Math.max(this.mediaToHealthRate, 0.0);
        }

        @Override
        public long dustMediaAmount() {
            return this.dustMediaAmount;
        }

        @Override
        public long shardMediaAmount() {
            return this.shardMediaAmount;
        }

        @Override
        public long chargedCrystalMediaAmount() {
            return this.chargedCrystalMediaAmount;
        }

        @Override
        public double mediaToHealthRate() {
            return this.mediaToHealthRate;
        }

        @Override
        public int cypherCooldown() {
            return this.cypherCooldown;
        }

        @Override
        public int trinketCooldown() {
            return this.trinketCooldown;
        }

        @Override
        public int artifactCooldown() {
            return this.artifactCooldown;
        }
    }

    @Config(name="client")
    public static final class Client
    implements HexConfig.ClientConfigAccess,
    ConfigData {
        @ConfigEntry.Gui.Tooltip
        private boolean ctrlTogglesOffStrokeOrder = false;
        @ConfigEntry.Gui.Tooltip
        private boolean invertSpellbookScrollDirection = false;
        @ConfigEntry.Gui.Tooltip
        private boolean invertAbacusScrollDirection = false;
        @ConfigEntry.Gui.Tooltip
        private double gridSnapThreshold = 0.5;
        @ConfigEntry.Gui.Tooltip
        private boolean clickingTogglesDrawing = false;
        @ConfigEntry.Gui.Tooltip
        private boolean alwaysShowListCommas = false;

        public void validatePostLoad() throws ConfigData.ValidationException {
            this.gridSnapThreshold = class_3532.method_15350((double)this.gridSnapThreshold, (double)0.5, (double)1.0);
        }

        @Override
        public boolean ctrlTogglesOffStrokeOrder() {
            return this.ctrlTogglesOffStrokeOrder;
        }

        @Override
        public boolean invertSpellbookScrollDirection() {
            return this.invertSpellbookScrollDirection;
        }

        @Override
        public boolean invertAbacusScrollDirection() {
            return this.invertAbacusScrollDirection;
        }

        @Override
        public double gridSnapThreshold() {
            return this.gridSnapThreshold;
        }

        @Override
        public boolean clickingTogglesDrawing() {
            return this.clickingTogglesDrawing;
        }

        @Override
        public boolean alwaysShowListCommas() {
            return this.alwaysShowListCommas;
        }
    }

    @Config(name="server")
    public static final class Server
    implements HexConfig.ServerConfigAccess,
    ConfigData {
        @ConfigEntry.BoundedDiscrete(min=0L, max=4L)
        @ConfigEntry.Gui.Tooltip
        private int opBreakHarvestLevel = 3;
        @ConfigEntry.Gui.Tooltip
        private int maxOpCount = 100000;
        @ConfigEntry.Gui.Tooltip
        private int maxSpellCircleLength = 1024;
        @ConfigEntry.Gui.Tooltip
        private List<String> actionDenyList = List.of();
        @ConfigEntry.Gui.Tooltip
        private List<String> circleActionDenyList = List.of();
        @ConfigEntry.Gui.Tooltip
        private boolean greaterTeleportSplatsItems = true;
        @ConfigEntry.Gui.Tooltip
        private boolean villagersOffendedByMindMurder = true;
        @ConfigEntry.Gui.Tooltip
        private boolean doesTrueNameHaveAmbit = true;
        @ConfigEntry.Gui.Tooltip
        private List<String> tpDimDenylist = DEFAULT_DIM_TP_DENYLIST;
        @ConfigEntry.Gui.Tooltip
        private double traderScrollChance = 0.2;
        @ConfigEntry.Gui.Tooltip
        private List<String> scrollInjectionsRaw = HexLootHandler.DEFAULT_SCROLL_INJECTS.stream().map(si -> si.injectee() + " " + si.countRange()).toList();
        @ConfigEntry.Gui.Excluded
        private transient Object2IntMap<class_2960> scrollInjections;
        @ConfigEntry.Gui.Tooltip
        private List<String> loreInjectionsRaw = HexLootHandler.DEFAULT_LORE_INJECTS.stream().map(class_2960::toString).toList();
        @ConfigEntry.Gui.Excluded
        private transient List<class_2960> loreInjections;
        @ConfigEntry.Gui.Tooltip
        private double loreChance = 0.4;
        @ConfigEntry.Gui.Tooltip
        private List<String> cypherInjectionsRaw = HexLootHandler.DEFAULT_CYPHER_INJECTS.stream().map(class_2960::toString).toList();
        @ConfigEntry.Gui.Excluded
        private transient List<class_2960> cypherInjections;
        @ConfigEntry.Gui.Tooltip
        private double cypherChance = 0.4;

        public void validatePostLoad() throws ConfigData.ValidationException {
            class_2960 loc;
            this.maxOpCount = Math.max(this.maxOpCount, 0);
            this.maxSpellCircleLength = Math.max(this.maxSpellCircleLength, 4);
            this.traderScrollChance = class_3532.method_15350((double)this.traderScrollChance, (double)0.0, (double)1.0);
            this.scrollInjections = new Object2IntOpenHashMap();
            try {
                for (String auugh : this.scrollInjectionsRaw) {
                    String[] split = auugh.split(" ");
                    class_2960 loc2 = new class_2960(split[0]);
                    int count = Integer.parseInt(split[1]);
                    this.scrollInjections.put((Object)loc2, count);
                }
            }
            catch (Exception e) {
                throw new ConfigData.ValidationException("Bad parsing of scroll injects", (Throwable)e);
            }
            this.loreInjections = new ArrayList<class_2960>();
            try {
                for (String table : this.loreInjectionsRaw) {
                    loc = new class_2960(table);
                    this.loreInjections.add(loc);
                }
            }
            catch (Exception e) {
                throw new ConfigData.ValidationException("Bad parsing of lore injects", (Throwable)e);
            }
            this.loreChance = class_3532.method_15350((double)this.loreChance, (double)0.0, (double)1.0);
            this.cypherInjections = new ArrayList<class_2960>();
            try {
                for (String table : this.cypherInjectionsRaw) {
                    loc = new class_2960(table);
                    this.cypherInjections.add(loc);
                }
            }
            catch (Exception e) {
                throw new ConfigData.ValidationException("Bad parsing of cypher injects", (Throwable)e);
            }
            this.cypherChance = class_3532.method_15350((double)this.cypherChance, (double)0.0, (double)1.0);
        }

        @Override
        public int opBreakHarvestLevelBecauseForgeThoughtItWasAGoodIdeaToImplementHarvestTiersUsingAnHonestToGodTopoSort() {
            return this.opBreakHarvestLevel;
        }

        @Override
        public int maxOpCount() {
            return this.maxOpCount;
        }

        @Override
        public int maxSpellCircleLength() {
            return this.maxSpellCircleLength;
        }

        @Override
        public boolean isActionAllowed(class_2960 actionID) {
            return HexConfig.noneMatch(this.actionDenyList, actionID);
        }

        @Override
        public boolean isActionAllowedInCircles(class_2960 actionID) {
            return HexConfig.noneMatch(this.circleActionDenyList, actionID);
        }

        @Override
        public boolean doesGreaterTeleportSplatItems() {
            return this.greaterTeleportSplatsItems;
        }

        @Override
        public boolean doVillagersTakeOffenseAtMindMurder() {
            return this.villagersOffendedByMindMurder;
        }

        @Override
        public boolean canTeleportInThisDimension(class_5321<class_1937> dimension) {
            return HexConfig.noneMatch(this.tpDimDenylist, dimension.method_29177());
        }

        @Override
        public boolean trueNameHasAmbit() {
            return this.doesTrueNameHaveAmbit;
        }

        @Override
        public double traderScrollChance() {
            return this.traderScrollChance;
        }

        public int scrollRangeForLootTable(class_2960 lootTable) {
            return this.scrollInjections.getOrDefault((Object)lootTable, -1);
        }

        public boolean shouldInjectLore(class_2960 lootTable) {
            return HexConfig.anyMatchResLoc(this.loreInjections, lootTable);
        }

        public double loreChance() {
            return this.loreChance;
        }

        public boolean shouldInjectCyphers(class_2960 lootTable) {
            return HexConfig.anyMatchResLoc(this.cypherInjections, lootTable);
        }

        public double cypherChance() {
            return this.cypherChance;
        }
    }
}

