/*
 * Decompiled with CFR 0.152.
 */
package love.marblegate.flowingagonyreborn.event.enchantment;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import love.marblegate.flowingagonyreborn.Config;
import love.marblegate.flowingagonyreborn.capibility.CoolDown;
import love.marblegate.flowingagonyreborn.capibility.ModCapManager;
import love.marblegate.flowingagonyreborn.damagesource.DamageSourceBuilder;
import love.marblegate.flowingagonyreborn.enchantment.diceoffraud.AnEnchantedGoldenAppleADayEnchantment;
import love.marblegate.flowingagonyreborn.enchantment.diceoffraud.DeathPunkEnchantment;
import love.marblegate.flowingagonyreborn.enchantment.diceoffraud.ExoticHealerEnchantment;
import love.marblegate.flowingagonyreborn.enchantment.diceoffraud.SavorTheTastedEnchantment;
import love.marblegate.flowingagonyreborn.enchantment.diceoffraud.TricksterEnchantment;
import love.marblegate.flowingagonyreborn.util.EnchantmentUtil;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0014H\u0007J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0017H\u0007\u00a8\u0006\u0018"}, d2={"Llove/marblegate/flowingagonyreborn/event/enchantment/DiceOfFraudEnchantmentHandler;", "", "<init>", "()V", "doTricksterEnchantmentEvent", "", "event", "Lnet/minecraftforge/event/entity/player/AttackEntityEvent;", "appendixEffectForTrickster", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "diceNum", "", "doAnEnchantedGoldenAppleADayEnchantmentEvent", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerChangeGameModeEvent;", "caseToAddEffect", "tempNum", "player", "Lnet/minecraft/world/entity/player/Player;", "doDeathpunkEnchantmentEvent", "Lnet/minecraftforge/event/entity/living/LivingDamageEvent;", "doSavorTheTastedEnchantmentEvent", "doExoticHealerEnchantmentEvent", "Lnet/minecraftforge/event/entity/living/LivingHealEvent;", "FlowingAgonyReborn-1.20.1"})
public final class DiceOfFraudEnchantmentHandler {
    @NotNull
    public static final DiceOfFraudEnchantmentHandler INSTANCE = new DiceOfFraudEnchantmentHandler();

    private DiceOfFraudEnchantmentHandler() {
    }

    @SubscribeEvent
    public final void doTricksterEnchantmentEvent(@NotNull AttackEntityEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        Entity entity = event.getTarget();
        if (entity == null) {
            return;
        }
        Entity target = entity;
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        Player player2 = player;
        if (target instanceof LivingEntity) {
            int enchantmentLevel = EnchantmentUtil.getEnchantmentLevel((LivingEntity)player2, TricksterEnchantment.INSTANCE, EquipmentSlot.MAINHAND);
            int diceNum = ((LivingEntity)target).m_217043_().m_188503_(5) + 1;
            int anotherDiceNum = ((LivingEntity)target).m_217043_().m_188503_(5) + 1;
            switch (enchantmentLevel) {
                case 1: {
                    this.appendixEffectForTrickster((LivingEntity)target, diceNum);
                    break;
                }
                case 2: {
                    while (diceNum == anotherDiceNum) {
                        anotherDiceNum = ((LivingEntity)target).m_217043_().m_188503_(5) + 1;
                    }
                    this.appendixEffectForTrickster((LivingEntity)target, diceNum);
                    this.appendixEffectForTrickster((LivingEntity)target, anotherDiceNum);
                }
            }
        }
    }

    private final void appendixEffectForTrickster(LivingEntity entity, int diceNum) {
        switch (diceNum) {
            case 1: {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100));
                break;
            }
            case 2: {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 100));
                break;
            }
            case 3: {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100));
                break;
            }
            case 4: {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100));
                break;
            }
            case 5: {
                entity.m_20254_(5);
            }
        }
    }

    @SubscribeEvent
    public final void doAnEnchantedGoldenAppleADayEnchantmentEvent(@NotNull PlayerEvent.PlayerChangeGameModeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        Player player2 = player;
        int enchantmentLevel = EnchantmentUtil.getArmorEnchantmentTotalLevel((LivingEntity)player2, AnEnchantedGoldenAppleADayEnchantment.INSTANCE);
        if (enchantmentLevel == 0) {
            return;
        }
        LazyOptional lazyOptional = event.getEntity().getCapability(ModCapManager.INSTANCE.getCoolDown_Capability());
        Intrinsics.checkNotNullExpressionValue((Object)lazyOptional, (String)"getCapability(...)");
        LazyOptional coolDownCap = lazyOptional;
        coolDownCap.ifPresent(arg_0 -> DiceOfFraudEnchantmentHandler.doAnEnchantedGoldenAppleADayEnchantmentEvent$lambda$1(arg_0 -> DiceOfFraudEnchantmentHandler.doAnEnchantedGoldenAppleADayEnchantmentEvent$lambda$0(enchantmentLevel, player2, arg_0), arg_0));
    }

    private final void caseToAddEffect(int tempNum, Player player) {
        switch (tempNum) {
            case 0: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 2400, 3));
                break;
            }
            case 1: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 400, 1));
                break;
            }
            case 2: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 6000));
                break;
            }
            case 3: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 6000));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void doDeathpunkEnchantmentEvent(@NotNull LivingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            LivingEntity livingEntity = event.getEntity();
            Intrinsics.checkNotNull((Object)livingEntity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player player = (Player)livingEntity;
            if (event.getAmount() < player.m_21223_() && event.getSource().m_276093_(DamageTypes.f_268724_)) {
                return;
            }
            if (EnchantmentUtil.isItemEnchanted((LivingEntity)player, DeathPunkEnchantment.INSTANCE, EquipmentSlot.CHEST)) {
                int solution = player.m_217043_().m_188503_(4);
                int health = Mth.m_14143_((float)player.m_21223_());
                int maxHealth = Mth.m_14143_((float)player.m_21233_());
                boolean damageEnchantment = false;
                switch (solution) {
                    case 0: {
                        int saturationLevel = Mth.m_14143_((float)player.m_36324_().m_38722_());
                        int foodLevel = player.m_36324_().m_38702_() + saturationLevel;
                        if (foodLevel <= health) {
                            damageEnchantment = true;
                            break;
                        }
                        if (foodLevel > maxHealth) {
                            foodLevel = maxHealth;
                        }
                        player.m_21153_((float)foodLevel);
                        player.m_36324_().m_38705_(health);
                        player.m_36324_().m_38703_(player.m_36324_().m_38722_() * (float)4);
                        break;
                    }
                    case 1: {
                        int oxygenLevel = Mth.m_14143_((float)(player.m_20146_() / player.m_6062_() / maxHealth));
                        if (oxygenLevel <= health) {
                            damageEnchantment = true;
                            break;
                        }
                        if (oxygenLevel > maxHealth) {
                            oxygenLevel = maxHealth;
                        }
                        player.m_21153_((float)oxygenLevel);
                        player.m_20301_(health * (player.m_6062_() / maxHealth));
                        break;
                    }
                    case 2: {
                        int expPoint = player.f_36079_;
                        int exchangeCost = Mth.m_14143_((float)(player.m_21233_() - (float)health)) * 30;
                        if (expPoint <= exchangeCost) {
                            damageEnchantment = true;
                            break;
                        }
                        player.m_21153_(player.m_21233_());
                        player.m_6756_(-exchangeCost);
                        break;
                    }
                    case 3: {
                        damageEnchantment = true;
                    }
                }
                if (damageEnchantment) {
                    player.m_21153_(player.m_21233_());
                    Map enchantments = EnchantmentHelper.m_44831_((ItemStack)player.m_6844_(EquipmentSlot.CHEST));
                    Intrinsics.checkNotNull((Object)enchantments);
                    enchantments.remove((Object)DeathPunkEnchantment.INSTANCE);
                    EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)player.m_6844_(EquipmentSlot.CHEST));
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public final void doSavorTheTastedEnchantmentEvent(@NotNull LivingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (event.getSource().m_7639_() instanceof Player) {
            Entity entity = event.getSource().m_7639_();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player player = (Player)entity;
            int enchantmentLevel = EnchantmentUtil.getEnchantmentLevel((LivingEntity)player, SavorTheTastedEnchantment.INSTANCE, EquipmentSlot.MAINHAND);
            if (enchantmentLevel == 0) {
                return;
            }
            CompoundTag weaponNbt = player.m_21205_().m_41783_();
            String string = event.getEntity().m_20078_();
            if (string == null) {
                return;
            }
            String encodeId = string;
            CompoundTag compoundTag = weaponNbt;
            if (!(compoundTag != null ? compoundTag.m_128441_("savor_the_tasted_target") : false)) {
                CompoundTag compoundTag2 = weaponNbt;
                if (compoundTag2 != null) {
                    compoundTag2.m_128359_("savor_the_tasted_target", encodeId);
                }
            } else {
                String string2 = weaponNbt.m_128461_("savor_the_tasted_target");
                if (string2 == null) {
                    return;
                }
                String recordedTarget = string2;
                if (Intrinsics.areEqual((Object)recordedTarget, (Object)encodeId)) {
                    float f = event.getAmount();
                    float f2 = player.m_217043_().m_188503_(5) + enchantmentLevel * 4 - 1;
                    Object object = Config.Companion.getNumericalSettings().getSavorTheTastedEnchantment().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    event.setAmount(f + f2 * ((Number)object).floatValue());
                } else {
                    weaponNbt.m_128359_("savor_the_tasted_target", encodeId);
                }
            }
            player.m_21205_().m_41751_(weaponNbt);
        }
    }

    @SubscribeEvent
    public final void doExoticHealerEnchantmentEvent(@NotNull LivingHealEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            LivingEntity livingEntity = event.getEntity();
            Intrinsics.checkNotNull((Object)livingEntity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player player = (Player)livingEntity;
            int enchantmentLevel = EnchantmentUtil.getArmorEnchantmentMaxLevel((LivingEntity)player, ExoticHealerEnchantment.INSTANCE);
            if (enchantmentLevel == 0) {
                return;
            }
            int dice = player.m_217043_().m_188503_(100);
            float modifier = 1.0f + (float)(enchantmentLevel - 1) * 0.1f;
            int duration = (int)((float)600 * modifier);
            RegistryAccess registryAccess = player.m_9236_().m_9598_();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            DamageSource source = DamageSourceBuilder.INSTANCE.causeExtremeHatred(registryAccess);
            if (dice < 33) {
                event.setCanceled(true);
            } else if (dice < 66) {
                event.setAmount(event.getAmount() * ((float)2 * modifier));
            } else if (dice < 91) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, duration));
            } else if (dice < 92) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, duration));
            } else if (dice < 93) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, duration));
            } else if (dice < 94) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, duration));
            } else if (dice < 95) {
                player.m_6469_(source, event.getAmount() * modifier);
                event.setCanceled(true);
            }
        }
    }

    private static final Unit doAnEnchantedGoldenAppleADayEnchantmentEvent$lambda$0(int $enchantmentLevel, Player $player, CoolDown cap) {
        Intrinsics.checkNotNullParameter((Object)cap, (String)"cap");
        if (cap.isReady(CoolDown.CoolDownType.AN_ENCHANTED_GOLDEN_APPLE_A_DAY)) {
            if ($enchantmentLevel == 1) {
                int tempNum = $player.m_217043_().m_188503_(4);
                INSTANCE.caseToAddEffect(tempNum, $player);
            } else if ($enchantmentLevel < 4) {
                Set set = new LinkedHashSet();
                int tempCount = $enchantmentLevel;
                while (tempCount > 0) {
                    int tempNum = $player.m_217043_().m_188503_(4);
                    if (set.contains(tempNum)) continue;
                    INSTANCE.caseToAddEffect(tempNum, $player);
                    Integer n = tempNum;
                    ((Collection)set).add(n);
                    --tempCount;
                }
            } else if ($enchantmentLevel == 4) {
                $player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 2400, 3));
                $player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 400, 1));
                $player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 6000));
                $player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 6000));
            }
            Object object = Config.Companion.getNumericalSettings().getAnAppleADayCoolDowns().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            cap.set(CoolDown.CoolDownType.AN_ENCHANTED_GOLDEN_APPLE_A_DAY, ((Number)object).intValue());
        }
        return Unit.INSTANCE;
    }

    private static final void doAnEnchantedGoldenAppleADayEnchantmentEvent$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        $tmp0.invoke(p0);
    }
}

