/*
 * Decompiled with CFR 0.152.
 */
package love.marblegate.flowingagonyreborn.event.enchantment;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import love.marblegate.flowingagonyreborn.Config;
import love.marblegate.flowingagonyreborn.effect.ModEffects;
import love.marblegate.flowingagonyreborn.enchantment.flameofenvy.CovertKnifeEnchantment;
import love.marblegate.flowingagonyreborn.enchantment.flameofenvy.EnviousKindEnchantment;
import love.marblegate.flowingagonyreborn.enchantment.flameofenvy.EyesoreEnchantment;
import love.marblegate.flowingagonyreborn.enchantment.flameofenvy.SourceOfEnvyEnchantment;
import love.marblegate.flowingagonyreborn.enchantment.flameofenvy.ThornInFleshEnchantment;
import love.marblegate.flowingagonyreborn.util.EffectUtil;
import love.marblegate.flowingagonyreborn.util.EnchantmentUtil;
import love.marblegate.flowingagonyreborn.util.EntityUtil;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\r"}, d2={"Llove/marblegate/flowingagonyreborn/event/enchantment/FlameOfEnvyEnchantmentEventHandler;", "", "<init>", "()V", "doEnviousKindEnchantmentEvent", "", "event", "Lnet/minecraftforge/event/entity/living/LivingDamageEvent;", "doEyesoreEnchantmentEvent", "doThornInFleshEnchantmentEvent", "doCovertKnifeEnchantmentEvent", "Lnet/minecraftforge/event/entity/ProjectileImpactEvent;", "doSourceOfEnvyEnchantmentEvent", "FlowingAgonyReborn-1.20.1"})
@SourceDebugExtension(value={"SMAP\nFlameOfEnvyEnchantmentEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlameOfEnvyEnchantmentEventHandler.kt\nlove/marblegate/flowingagonyreborn/event/enchantment/FlameOfEnvyEnchantmentEventHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1863#2,2:172\n1863#2:174\n1864#2:176\n1863#2,2:177\n1#3:175\n*S KotlinDebug\n*F\n+ 1 FlameOfEnvyEnchantmentEventHandler.kt\nlove/marblegate/flowingagonyreborn/event/enchantment/FlameOfEnvyEnchantmentEventHandler\n*L\n128#1:172,2\n158#1:174\n158#1:176\n166#1:177,2\n*E\n"})
public final class FlameOfEnvyEnchantmentEventHandler {
    @NotNull
    public static final FlameOfEnvyEnchantmentEventHandler INSTANCE = new FlameOfEnvyEnchantmentEventHandler();

    private FlameOfEnvyEnchantmentEventHandler() {
    }

    @SubscribeEvent
    public final void doEnviousKindEnchantmentEvent(@NotNull LivingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (event.getSource().m_7639_() instanceof Player) {
            Entity entity = event.getSource().m_7639_();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player player = (Player)entity;
            int enchantmentLevel = EnchantmentUtil.getEnchantmentLevel((LivingEntity)player, EnviousKindEnchantment.INSTANCE, EquipmentSlot.CHEST);
            if (enchantmentLevel == 0) {
                return;
            }
            float diff = event.getEntity().m_21223_() - player.m_21223_();
            if (diff <= 0.0f) {
                return;
            }
            int temp = (int)Math.floor((double)diff / 10.0);
            int amplifier = ((Boolean)Config.Companion.getAcquirableSettings().isFixEnviousKind().get()).booleanValue() ? (temp > 10 ? 10 : temp) : temp;
            player.m_7292_(new MobEffectInstance(ModEffects.INSTANCE.getENVIOUS_BEING(), 200, amplifier));
        }
    }

    @SubscribeEvent
    public final void doEyesoreEnchantmentEvent(@NotNull LivingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (event.getSource().m_7639_() instanceof Player) {
            Entity entity = event.getSource().m_7639_();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player player = (Player)entity;
            int enchantmentLevel = EnchantmentUtil.getEnchantmentLevel((LivingEntity)player, EyesoreEnchantment.INSTANCE, EquipmentSlot.MAINHAND);
            if (enchantmentLevel != 0) {
                event.getEntity().m_7292_(EffectUtil.INSTANCE.genImplicitEffect(ModEffects.INSTANCE.getEYESORE_ENCHANTMENT_ACTIVE(), 61, enchantmentLevel - 1));
            }
        }
    }

    @SubscribeEvent
    public final void doThornInFleshEnchantmentEvent(@NotNull LivingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getSource().m_7639_() instanceof Player) {
            Entity entity = event.getSource().m_7639_();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player player = (Player)entity;
            int enchantmentLevel = EnchantmentUtil.getEnchantmentLevel((LivingEntity)player, ThornInFleshEnchantment.INSTANCE, EquipmentSlot.MAINHAND);
            if (enchantmentLevel != 0) {
                boolean bl = event.getEntity() instanceof Player ? event.getEntity().m_7292_(EffectUtil.INSTANCE.genImplicitEffect(ModEffects.INSTANCE.getTHORN_IN_FLESH_ACTIVE_FOR_PLAYER(), 60 + 40 * enchantmentLevel, enchantmentLevel - 1)) : event.getEntity().m_7292_(EffectUtil.INSTANCE.genImplicitEffect(ModEffects.INSTANCE.getTHORN_IN_FLESH_ACTIVE(), 60 + 40 * enchantmentLevel, enchantmentLevel - 1));
            }
        }
    }

    @SubscribeEvent
    public final void doCovertKnifeEnchantmentEvent(@NotNull ProjectileImpactEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (event.getRayTraceResult() instanceof EntityHitResult) {
            HitResult hitResult = event.getRayTraceResult();
            Intrinsics.checkNotNull((Object)hitResult, (String)"null cannot be cast to non-null type net.minecraft.world.phys.EntityHitResult");
            Entity entity = ((EntityHitResult)hitResult).m_82443_();
            if (entity instanceof EnderMan) {
                Entity entity2 = event.getProjectile().m_19749_();
                if (entity2 == null) {
                    return;
                }
                Entity owner = entity2;
                if (owner instanceof Player) {
                    Projectile projectile;
                    double successProbability;
                    int enchantmentLevel = EnchantmentUtil.getEnchantmentLevel((LivingEntity)owner, CovertKnifeEnchantment.INSTANCE, EquipmentSlot.MAINHAND);
                    if (enchantmentLevel == 0) {
                        return;
                    }
                    switch (enchantmentLevel) {
                        case 3: {
                            double d = 1.0;
                            break;
                        }
                        case 2: {
                            double d = 0.75;
                            break;
                        }
                        case 1: {
                            double d = 0.5;
                            break;
                        }
                        default: {
                            double d = successProbability = 0.0;
                        }
                    }
                    if (Random.Default.nextDouble() >= successProbability) {
                        return;
                    }
                    ((EnderMan)entity).m_6469_(owner.m_269291_().m_269075_((Player)owner), 9.0f);
                    LivingEntity livingEntity = (LivingEntity)owner;
                    Enchantment enchantment = Enchantments.f_44990_;
                    Intrinsics.checkNotNullExpressionValue((Object)enchantment, (String)"FLAMING_ARROWS");
                    if (EnchantmentUtil.getEnchantmentLevel(livingEntity, enchantment, EquipmentSlot.MAINHAND) == 1) {
                        ((EnderMan)entity).m_20254_(5);
                    }
                    if ((projectile = event.getProjectile()) instanceof SpectralArrow) {
                        ((EnderMan)entity).m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200));
                    } else if (projectile instanceof Arrow) {
                        Projectile projectile2 = event.getProjectile();
                        Intrinsics.checkNotNull((Object)projectile2, (String)"null cannot be cast to non-null type net.minecraft.world.entity.projectile.Arrow");
                        Potion potion = (Potion)ObfuscationReflectionHelper.getPrivateValue(Arrow.class, (Object)((Arrow)projectile2), (String)"potion");
                        if (potion == null) {
                            return;
                        }
                        Potion potion2 = potion;
                        if (!Intrinsics.areEqual((Object)potion2, (Object)Potions.f_43598_)) {
                            List list = potion2.m_43488_();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEffects(...)");
                            Iterable $this$forEach$iv = list;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                MobEffectInstance it = (MobEffectInstance)element$iv;
                                boolean bl = false;
                                if (it == null) continue;
                                int duration = Mth.m_14167_((float)((float)it.m_19557_() * 0.125f));
                                ((EnderMan)entity).m_7292_(new MobEffectInstance(it.m_19544_(), duration, it.m_19564_()));
                            }
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public final void doSourceOfEnvyEnchantmentEvent(@NotNull LivingDamageEvent event) {
        block7: {
            int enchantmentLevel;
            Player player;
            block8: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getEntity().m_9236_().f_46443_) {
                    return;
                }
                if (event.isCanceled()) {
                    return;
                }
                if (!(event.getEntity() instanceof Player) || !(event.getSource().m_7639_() instanceof LivingEntity)) break block7;
                LivingEntity livingEntity = event.getEntity();
                Intrinsics.checkNotNull((Object)livingEntity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
                player = (Player)livingEntity;
                enchantmentLevel = EnchantmentUtil.getEnchantmentLevel((LivingEntity)player, SourceOfEnvyEnchantment.INSTANCE, EquipmentSlot.CHEST);
                if (enchantmentLevel == 0) {
                    return;
                }
                if (!(event.getSource().m_7639_() instanceof Player)) break block8;
                List<LivingEntity> availableEnvySpreadTargets = EntityUtil.getTargetsExceptOneself((LivingEntity)player, 12.0f, 2.0f, FlameOfEnvyEnchantmentEventHandler::doSourceOfEnvyEnchantmentEvent$lambda$1);
                if (!((Collection)availableEnvySpreadTargets).isEmpty()) {
                    Iterable $this$forEach$iv = availableEnvySpreadTargets;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        LivingEntity it = (LivingEntity)element$iv;
                        boolean bl = false;
                        if (!(Math.random() < 0.08 + 0.02 * (double)enchantmentLevel)) continue;
                        if (event.getSource().m_7639_() != null) {
                            Entity spreadTarget;
                            boolean bl2 = false;
                            it.m_21335_(spreadTarget);
                        }
                    }
                }
                break block7;
            }
            Entity entity = event.getSource().m_7639_();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
            LivingEntity sourceEntity = (LivingEntity)entity;
            List<LivingEntity> availableEnvySpreadTargets = EntityUtil.getTargetsOfSameType((LivingEntity)player, 12.0f, 2.0f, sourceEntity, true);
            if (!(!((Collection)availableEnvySpreadTargets).isEmpty())) break block7;
            Iterable $this$forEach$iv = availableEnvySpreadTargets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LivingEntity it = (LivingEntity)element$iv;
                boolean bl = false;
                if (!(Math.random() < 0.15 + 0.05 * (double)enchantmentLevel)) continue;
                it.m_21335_((Entity)sourceEntity);
            }
        }
    }

    private static final boolean doSourceOfEnvyEnchantmentEvent$lambda$1(LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        return EntityUtil.isHostile(livingEntity, false);
    }
}

