/*
 * Decompiled with CFR 0.152.
 */
package love.marblegate.flowingagonyreborn.event.enchantment;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import love.marblegate.flowingagonyreborn.Config;
import love.marblegate.flowingagonyreborn.damagesource.ModDamageTypes;
import love.marblegate.flowingagonyreborn.enchantment.survivaltricks.NecessaryEvilEnchantment;
import love.marblegate.flowingagonyreborn.enchantment.survivaltricks.SurvivalRuseEnchantment;
import love.marblegate.flowingagonyreborn.enchantment.survivaltricks.SurvivalShortcutEnchantment;
import love.marblegate.flowingagonyreborn.util.EnchantmentUtil;
import love.marblegate.flowingagonyreborn.util.EntityUtil;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J.\u0010\n\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0012\u001a\u00020\r2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Llove/marblegate/flowingagonyreborn/event/enchantment/SurvivalTricksEnchantmentEventHandler;", "", "<init>", "()V", "doSurvivalShortcutEnchantmentEvent", "", "event", "Lnet/minecraftforge/event/entity/living/LivingDamageEvent;", "doSurvivalSRuseEnchantmentEvent", "doNecessaryEvilEnchantmentEvent", "damageTransfer", "entities", "", "Lnet/minecraft/world/entity/LivingEntity;", "level", "", "shareMode", "", "getLuckyOne", "source", "Lnet/minecraft/util/RandomSource;", "FlowingAgonyReborn-1.20.1"})
@SourceDebugExtension(value={"SMAP\nSurvivalTricksEnchantmentEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SurvivalTricksEnchantmentEventHandler.kt\nlove/marblegate/flowingagonyreborn/event/enchantment/SurvivalTricksEnchantmentEventHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1863#2,2:109\n*S KotlinDebug\n*F\n+ 1 SurvivalTricksEnchantmentEventHandler.kt\nlove/marblegate/flowingagonyreborn/event/enchantment/SurvivalTricksEnchantmentEventHandler\n*L\n89#1:109,2\n*E\n"})
public final class SurvivalTricksEnchantmentEventHandler {
    @NotNull
    public static final SurvivalTricksEnchantmentEventHandler INSTANCE = new SurvivalTricksEnchantmentEventHandler();

    private SurvivalTricksEnchantmentEventHandler() {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public final void doSurvivalShortcutEnchantmentEvent(@NotNull LivingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (!event.getSource().m_276093_(DamageTypes.f_268724_) && !event.getSource().m_276093_(ModDamageTypes.INSTANCE.getBurial_object_curse()) && event.getEntity() instanceof Player) {
            LivingEntity livingEntity = event.getEntity();
            Intrinsics.checkNotNull((Object)livingEntity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player player = (Player)livingEntity;
            int enchantmentLevel = EnchantmentUtil.getEnchantmentLevel((LivingEntity)player, SurvivalShortcutEnchantment.INSTANCE, EquipmentSlot.CHEST);
            if (enchantmentLevel == 0) {
                return;
            }
            if (event.getSource().m_7639_() instanceof Player) {
                event.setAmount(event.getAmount() * (0.95f - 0.05f * (float)enchantmentLevel));
            } else if (event.getAmount() >= (float)(9 - enchantmentLevel)) {
                List<LivingEntity> entities = (Boolean)Config.Companion.getGeneralSettings().getVillagerSafeMode().get() != false ? EntityUtil.getTargetsExceptOneself((LivingEntity)player, 16.0f, 2.0f, SurvivalTricksEnchantmentEventHandler::doSurvivalShortcutEnchantmentEvent$lambda$0) : EntityUtil.getTargetsExceptOneself((LivingEntity)player, 16.0f, 2.0f, SurvivalTricksEnchantmentEventHandler::doSurvivalShortcutEnchantmentEvent$lambda$1);
                this.damageTransfer(entities, event, enchantmentLevel, false);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public final void doSurvivalSRuseEnchantmentEvent(@NotNull LivingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (!event.getSource().m_276093_(DamageTypes.f_268724_) && !event.getSource().m_276093_(ModDamageTypes.INSTANCE.getBurial_object_curse()) && event.getEntity() instanceof Player) {
            LivingEntity livingEntity = event.getEntity();
            Intrinsics.checkNotNull((Object)livingEntity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player player = (Player)livingEntity;
            int enchantmentLevel = EnchantmentUtil.getEnchantmentLevel((LivingEntity)player, SurvivalRuseEnchantment.INSTANCE, EquipmentSlot.CHEST);
            if (enchantmentLevel == 0) {
                return;
            }
            if (event.getSource().m_7639_() instanceof Player) {
                event.setAmount(event.getAmount() * (0.95f - 0.05f * (float)enchantmentLevel));
            } else if (event.getAmount() >= (float)(9 - enchantmentLevel)) {
                List<LivingEntity> entities = EntityUtil.getTargetsExceptOneself((LivingEntity)player, 16.0f, 2.0f, SurvivalTricksEnchantmentEventHandler::doSurvivalSRuseEnchantmentEvent$lambda$2);
                this.damageTransfer(entities, event, enchantmentLevel, false);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public final void doNecessaryEvilEnchantmentEvent(@NotNull LivingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (!event.getSource().m_276093_(DamageTypes.f_268724_) && !event.getSource().m_276093_(ModDamageTypes.INSTANCE.getBurial_object_curse()) && event.getEntity() instanceof Player) {
            LivingEntity livingEntity = event.getEntity();
            Intrinsics.checkNotNull((Object)livingEntity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player player = (Player)livingEntity;
            int enchantmentLevel = EnchantmentUtil.getEnchantmentLevel((LivingEntity)player, NecessaryEvilEnchantment.INSTANCE, EquipmentSlot.CHEST);
            if (enchantmentLevel == 0) {
                return;
            }
            if (event.getSource().m_7639_() instanceof Player) {
                event.setAmount(event.getAmount() * (0.85f - 0.05f * (float)enchantmentLevel));
            } else if (event.getAmount() >= (float)(13 - enchantmentLevel)) {
                List<LivingEntity> entities = (Boolean)Config.Companion.getGeneralSettings().getVillagerSafeMode().get() != false ? EntityUtil.getTargetsExceptOneself((LivingEntity)player, 16.0f, 2.0f, SurvivalTricksEnchantmentEventHandler::doNecessaryEvilEnchantmentEvent$lambda$3) : EntityUtil.getTargetsExceptOneself((LivingEntity)player, 16.0f, 2.0f, SurvivalTricksEnchantmentEventHandler::doNecessaryEvilEnchantmentEvent$lambda$4);
                this.damageTransfer(entities, event, enchantmentLevel, true);
            }
        }
    }

    private final void damageTransfer(List<? extends LivingEntity> entities, LivingDamageEvent event, int level, boolean shareMode) {
        if (!entities.isEmpty()) {
            if (shareMode) {
                float damageSharedPerEntity = event.getAmount() / (float)entities.size();
                Iterable $this$forEach$iv = entities;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LivingEntity it = (LivingEntity)element$iv;
                    boolean bl = false;
                    it.m_6469_(it.m_269291_().m_269264_(), damageSharedPerEntity);
                }
            } else {
                LivingEntity livingEntity;
                if (entities.size() == 1) {
                    livingEntity = entities.get(0);
                } else {
                    RandomSource randomSource = event.getEntity().m_217043_();
                    Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"getRandom(...)");
                    livingEntity = this.getLuckyOne(entities, randomSource);
                }
                LivingEntity target = livingEntity;
                target.m_6469_(target.m_269291_().m_269264_(), event.getAmount());
            }
            event.setCanceled(true);
        } else if (event.getSource().m_276093_(DamageTypes.f_268565_)) {
            event.setAmount(event.getAmount() * (shareMode ? 0.7f - (float)level * 0.1f : 0.9f - (float)level * 0.1f));
        } else {
            event.setAmount(event.getAmount() * (shareMode ? 0.85f - (float)level * 0.05f : 0.95f - (float)level * 0.05f));
        }
    }

    private final LivingEntity getLuckyOne(List<? extends LivingEntity> entities, RandomSource source) {
        return entities.get(source.m_188503_(entities.size()));
    }

    private static final boolean doSurvivalShortcutEnchantmentEvent$lambda$0(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !EntityUtil.isHostile(it, false) && !(it instanceof Villager);
    }

    private static final boolean doSurvivalShortcutEnchantmentEvent$lambda$1(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !EntityUtil.isHostile(it, false);
    }

    private static final boolean doSurvivalSRuseEnchantmentEvent$lambda$2(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return EntityUtil.isHostile(it, false);
    }

    private static final boolean doNecessaryEvilEnchantmentEvent$lambda$3(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it instanceof Player) && !(it instanceof Villager);
    }

    private static final boolean doNecessaryEvilEnchantmentEvent$lambda$4(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it instanceof Player);
    }
}

