/*
 * Decompiled with CFR 0.152.
 */
package love.marblegate.flowingagonyreborn.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import love.marblegate.flowingagonyreborn.util.LivingEntityUtil;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\u0007\u001a\u00020\b*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000b\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\f\u001a\u00020\b*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\r\u001a\u00020\b*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u000e\u001a\u00020\b*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n\u001a\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0011"}, d2={"isItemEnchanted", "", "Lnet/minecraft/world/item/ItemStack;", "enchantment", "Lnet/minecraft/world/item/enchantment/Enchantment;", "allArmorHasEnchantment", "Lnet/minecraft/world/entity/LivingEntity;", "getEnchantmentLevel", "", "slot", "Lnet/minecraft/world/entity/EquipmentSlot;", "armorHasEnchantment", "getArmorEnchantmentCount", "getArmorEnchantmentTotalLevel", "getArmorEnchantmentMaxLevel", "getStackWithEnchantment", "", "FlowingAgonyReborn-1.20.1"})
@JvmName(name="EnchantmentUtil")
@SourceDebugExtension(value={"SMAP\nEnchantmentUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnchantmentUtil.kt\nlove/marblegate/flowingagonyreborn/util/EnchantmentUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1734#2,3:86\n1863#2,2:89\n1863#2,2:91\n1863#2,2:93\n1863#2,2:95\n1863#2,2:97\n*S KotlinDebug\n*F\n+ 1 EnchantmentUtil.kt\nlove/marblegate/flowingagonyreborn/util/EnchantmentUtil\n*L\n20#1:86,3\n40#1:89,2\n49#1:91,2\n58#1:93,2\n67#1:95,2\n81#1:97,2\n*E\n"})
public final class EnchantmentUtil {
    public static final boolean isItemEnchanted(@NotNull ItemStack $this$isItemEnchanted, @NotNull Enchantment enchantment) {
        Intrinsics.checkNotNullParameter((Object)$this$isItemEnchanted, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        return $this$isItemEnchanted.getAllEnchantments().containsKey(enchantment);
    }

    public static final boolean allArmorHasEnchantment(@NotNull LivingEntity $this$allArmorHasEnchantment, @NotNull Enchantment enchantment) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$allArmorHasEnchantment, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
            Iterable iterable = $this$allArmorHasEnchantment.m_6168_();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getArmorSlots(...)");
            Iterable $this$all$iv = iterable;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ItemStack it = (ItemStack)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (EnchantmentUtil.isItemEnchanted(it, enchantment)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final int getEnchantmentLevel(@NotNull LivingEntity $this$getEnchantmentLevel, @NotNull Enchantment enchantment, @NotNull EquipmentSlot slot) {
        Intrinsics.checkNotNullParameter((Object)$this$getEnchantmentLevel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        return switch (WhenMappings.$EnumSwitchMapping$0[slot.ordinal()]) {
            case 1 -> {
                Integer v0 = (Integer)LivingEntityUtil.getHelmet($this$getEnchantmentLevel).getAllEnchantments().get(enchantment);
                if (v0 != null) {
                    yield v0;
                }
                yield 0;
            }
            case 2 -> {
                Integer v2 = (Integer)LivingEntityUtil.getChestplate($this$getEnchantmentLevel).getAllEnchantments().get(enchantment);
                if (v2 != null) {
                    yield v2;
                }
                yield 0;
            }
            case 3 -> {
                Integer v3 = (Integer)LivingEntityUtil.getLeggings($this$getEnchantmentLevel).getAllEnchantments().get(enchantment);
                if (v3 != null) {
                    yield v3;
                }
                yield 0;
            }
            case 4 -> {
                Integer v4 = (Integer)LivingEntityUtil.getBoots($this$getEnchantmentLevel).getAllEnchantments().get(enchantment);
                if (v4 != null) {
                    yield v4;
                }
                yield 0;
            }
            case 5 -> {
                Integer v5 = (Integer)$this$getEnchantmentLevel.m_21205_().getAllEnchantments().get(enchantment);
                if (v5 != null) {
                    yield v5;
                }
                yield 0;
            }
            case 6 -> {
                Integer v6 = (Integer)$this$getEnchantmentLevel.m_21206_().getAllEnchantments().get(enchantment);
                if (v6 != null) {
                    yield v6;
                }
                yield 0;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final boolean armorHasEnchantment(@NotNull LivingEntity $this$armorHasEnchantment, @NotNull Enchantment enchantment) {
        Intrinsics.checkNotNullParameter((Object)$this$armorHasEnchantment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        Iterable iterable = $this$armorHasEnchantment.m_6168_();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getArmorSlots(...)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack it = (ItemStack)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!EnchantmentUtil.isItemEnchanted(it, enchantment)) continue;
            return true;
        }
        return false;
    }

    public static final int getArmorEnchantmentCount(@NotNull LivingEntity $this$getArmorEnchantmentCount, @NotNull Enchantment enchantment) {
        Intrinsics.checkNotNullParameter((Object)$this$getArmorEnchantmentCount, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        int count = 0;
        Iterable iterable = $this$getArmorEnchantmentCount.m_6168_();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getArmorSlots(...)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack it = (ItemStack)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!EnchantmentUtil.isItemEnchanted(it, enchantment)) continue;
            ++count;
        }
        return count;
    }

    public static final int getArmorEnchantmentTotalLevel(@NotNull LivingEntity $this$getArmorEnchantmentTotalLevel, @NotNull Enchantment enchantment) {
        Intrinsics.checkNotNullParameter((Object)$this$getArmorEnchantmentTotalLevel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        int level = 0;
        Iterable iterable = $this$getArmorEnchantmentTotalLevel.m_6168_();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getArmorSlots(...)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack it = (ItemStack)element$iv;
            boolean bl = false;
            Integer n = (Integer)it.getAllEnchantments().get(enchantment);
            level += n != null ? n : 0;
        }
        return level;
    }

    public static final int getArmorEnchantmentMaxLevel(@NotNull LivingEntity $this$getArmorEnchantmentMaxLevel, @NotNull Enchantment enchantment) {
        Intrinsics.checkNotNullParameter((Object)$this$getArmorEnchantmentMaxLevel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        int maxLevel = 0;
        Iterable iterable = $this$getArmorEnchantmentMaxLevel.m_6168_();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getArmorSlots(...)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack it = (ItemStack)element$iv;
            boolean bl = false;
            int n = maxLevel;
            Integer n2 = (Integer)it.getAllEnchantments().get(enchantment);
            int n3 = n2 != null ? n2 : 0;
            maxLevel = Math.max(n, n3);
        }
        return maxLevel;
    }

    public static final boolean isItemEnchanted(@NotNull LivingEntity $this$isItemEnchanted, @NotNull Enchantment enchantment, @NotNull EquipmentSlot slot) {
        Intrinsics.checkNotNullParameter((Object)$this$isItemEnchanted, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)$this$isItemEnchanted.m_6844_(slot));
        return enchantments.containsKey(enchantment);
    }

    @NotNull
    public static final List<ItemStack> getStackWithEnchantment(@NotNull LivingEntity $this$getStackWithEnchantment, @NotNull Enchantment enchantment) {
        Intrinsics.checkNotNullParameter((Object)$this$getStackWithEnchantment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        List list = new ArrayList();
        Iterable $this$forEach$iv = (Iterable)EntriesMappings.entries$0;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EquipmentSlot it = (EquipmentSlot)element$iv;
            boolean bl = false;
            if (!EnchantmentUtil.isItemEnchanted($this$getStackWithEnchantment, enchantment, it)) continue;
            ((Collection)list).add($this$getStackWithEnchantment.m_6844_(it));
        }
        return list;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<EquipmentSlot> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EquipmentSlot.values()));
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EquipmentSlot.values().length];
            try {
                nArray[EquipmentSlot.HEAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EquipmentSlot.CHEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EquipmentSlot.LEGS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EquipmentSlot.FEET.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EquipmentSlot.MAINHAND.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EquipmentSlot.OFFHAND.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

