/*
 * Decompiled with CFR 0.152.
 */
package love.marblegate.flowingagonyreborn.util;

import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\u001a.\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u001a0\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000b\u001a\u0012\u0010\u000e\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000b\u001a\n\u0010\u000f\u001a\u00020\u000b*\u00020\u0002\u001a\n\u0010\u0010\u001a\u00020\u000b*\u00020\u0002\u001a\n\u0010\u0011\u001a\u00020\u000b*\u00020\u0002\u001a\n\u0010\u0012\u001a\u00020\u000b*\u00020\u0002\u00a8\u0006\u0013"}, d2={"getTargetsExceptOneself", "", "Lnet/minecraft/world/entity/LivingEntity;", "radius", "", "height", "predicate", "Ljava/util/function/Predicate;", "getTargetsOfSameType", "sourceEntity", "excludeOneself", "", "isHostile", "restrictMode", "isNeutral", "isAggresiveUndead", "isCommonUndead", "isRareUndead", "supportHeadDrop", "FlowingAgonyReborn-1.20.1"})
@JvmName(name="EntityUtil")
public final class EntityUtil {
    @NotNull
    public static final List<LivingEntity> getTargetsExceptOneself(@NotNull LivingEntity $this$getTargetsExceptOneself, float radius, float height, @NotNull Predicate<LivingEntity> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$getTargetsExceptOneself, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        AABB aabb = new AABB((double)((float)$this$getTargetsExceptOneself.m_20183_().m_123341_() - radius), (double)((float)$this$getTargetsExceptOneself.m_20183_().m_123342_() - height), (double)((float)$this$getTargetsExceptOneself.m_20183_().m_123343_() - radius), (double)((float)$this$getTargetsExceptOneself.m_20183_().m_123341_() + radius), (double)((float)$this$getTargetsExceptOneself.m_20183_().m_123342_() + height), (double)((float)$this$getTargetsExceptOneself.m_20183_().m_123343_() + radius));
        List entities = $this$getTargetsExceptOneself.m_9236_().m_6443_(LivingEntity.class, aabb, predicate);
        entities.remove($this$getTargetsExceptOneself);
        Intrinsics.checkNotNull((Object)entities);
        return entities;
    }

    @NotNull
    public static final List<LivingEntity> getTargetsOfSameType(@NotNull LivingEntity $this$getTargetsOfSameType, float radius, float height, @NotNull LivingEntity sourceEntity, boolean excludeOneself) {
        Intrinsics.checkNotNullParameter((Object)$this$getTargetsOfSameType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sourceEntity, (String)"sourceEntity");
        AABB aabb = new AABB((double)((float)$this$getTargetsOfSameType.m_20183_().m_123341_() - radius), (double)((float)$this$getTargetsOfSameType.m_20183_().m_123342_() - height), (double)((float)$this$getTargetsOfSameType.m_20183_().m_123343_() - radius), (double)((float)$this$getTargetsOfSameType.m_20183_().m_123341_() + radius), (double)((float)$this$getTargetsOfSameType.m_20183_().m_123342_() + height), (double)((float)$this$getTargetsOfSameType.m_20183_().m_123343_() + radius));
        List entities = $this$getTargetsOfSameType.m_9236_().m_6443_(LivingEntity.class, aabb, arg_0 -> EntityUtil.getTargetsOfSameType$lambda$1(arg_0 -> EntityUtil.getTargetsOfSameType$lambda$0(sourceEntity, arg_0), arg_0));
        if (excludeOneself) {
            entities.remove($this$getTargetsOfSameType);
        }
        Intrinsics.checkNotNull((Object)entities);
        return entities;
    }

    public static final boolean isHostile(@NotNull LivingEntity $this$isHostile, boolean restrictMode) {
        Intrinsics.checkNotNullParameter((Object)$this$isHostile, (String)"<this>");
        return restrictMode ? $this$isHostile instanceof Monster && !($this$isHostile instanceof Piglin) && !($this$isHostile instanceof Spider) && !($this$isHostile instanceof EnderMan) || $this$isHostile instanceof Slime || $this$isHostile instanceof FlyingMob || $this$isHostile instanceof Hoglin || $this$isHostile instanceof EnderDragon : $this$isHostile instanceof Monster || $this$isHostile instanceof Slime || $this$isHostile instanceof FlyingMob || $this$isHostile instanceof Hoglin || $this$isHostile instanceof EnderDragon;
    }

    public static final boolean isNeutral(@NotNull LivingEntity $this$isNeutral, boolean restrictMode) {
        Intrinsics.checkNotNullParameter((Object)$this$isNeutral, (String)"<this>");
        return restrictMode ? EntityUtil.isNeutral($this$isNeutral, false) || $this$isNeutral instanceof EnderMan || $this$isNeutral instanceof Piglin || $this$isNeutral instanceof ZombifiedPiglin || $this$isNeutral instanceof Spider : $this$isNeutral instanceof Bee || $this$isNeutral instanceof Dolphin || $this$isNeutral instanceof IronGolem || $this$isNeutral instanceof Wolf || $this$isNeutral instanceof Panda || $this$isNeutral instanceof PolarBear || $this$isNeutral instanceof Llama;
    }

    public static final boolean isAggresiveUndead(@NotNull LivingEntity $this$isAggresiveUndead) {
        Intrinsics.checkNotNullParameter((Object)$this$isAggresiveUndead, (String)"<this>");
        return EntityUtil.isCommonUndead($this$isAggresiveUndead) || EntityUtil.isRareUndead($this$isAggresiveUndead) || $this$isAggresiveUndead instanceof WitherBoss;
    }

    public static final boolean isCommonUndead(@NotNull LivingEntity $this$isCommonUndead) {
        Intrinsics.checkNotNullParameter((Object)$this$isCommonUndead, (String)"<this>");
        return $this$isCommonUndead instanceof Zombie || $this$isCommonUndead instanceof Skeleton;
    }

    public static final boolean isRareUndead(@NotNull LivingEntity $this$isRareUndead) {
        Intrinsics.checkNotNullParameter((Object)$this$isRareUndead, (String)"<this>");
        return $this$isRareUndead instanceof Phantom || $this$isRareUndead instanceof WitherSkeleton || $this$isRareUndead instanceof Stray;
    }

    public static final boolean supportHeadDrop(@NotNull LivingEntity $this$supportHeadDrop) {
        Intrinsics.checkNotNullParameter((Object)$this$supportHeadDrop, (String)"<this>");
        return $this$supportHeadDrop instanceof Zombie && !($this$supportHeadDrop instanceof ZombieVillager) && !($this$supportHeadDrop instanceof ZombifiedPiglin) && !($this$supportHeadDrop instanceof Husk) || $this$supportHeadDrop instanceof Skeleton || $this$supportHeadDrop instanceof Creeper || $this$supportHeadDrop instanceof EnderDragon || $this$supportHeadDrop instanceof WitherSkeleton;
    }

    private static final boolean getTargetsOfSameType$lambda$0(LivingEntity $sourceEntity, LivingEntity livingEntity) {
        return Intrinsics.areEqual(livingEntity.getClass(), $sourceEntity.getClass());
    }

    private static final boolean getTargetsOfSameType$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

