/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.vampiricllamas;

import com.mojang.logging.LogUtils;
import com.startraveler.vampiricllamas.Config;
import com.startraveler.vampiricllamas.VampiricLlamasArmorMaterials;
import com.startraveler.vampiricllamas.VampiricLlamasBlocks;
import com.startraveler.vampiricllamas.VampiricLlamasCreativeModeTabs;
import com.startraveler.vampiricllamas.VampiricLlamasDataComponents;
import com.startraveler.vampiricllamas.VampiricLlamasEffects;
import com.startraveler.vampiricllamas.VampiricLlamasEntities;
import com.startraveler.vampiricllamas.VampiricLlamasItems;
import com.startraveler.vampiricllamas.VampiricLlamasStructureProcessors;
import com.startraveler.vampiricllamas.data.VampiricLlamasBlockTagProvider;
import com.startraveler.vampiricllamas.data.VampiricLlamasEnglishUSLanguageProvider;
import com.startraveler.vampiricllamas.data.VampiricLlamasEntityTypeTagProvider;
import com.startraveler.vampiricllamas.data.VampiricLlamasItemModelProvider;
import com.startraveler.vampiricllamas.data.VampiricLlamasItemTagProvider;
import com.startraveler.vampiricllamas.data.VampiricLlamasMobEffectTagProvider;
import com.startraveler.vampiricllamas.data.VampiricLlamasRecipeProvider;
import com.startraveler.vampiricllamas.entity.VampireLlama;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.EntityStruckByLightningEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Mod(value="vampiricllamas")
public class VampiricLlamas {
    public static final String MODID = "vampiricllamas";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final TagKey<Item> INVISIBLE_ARMOR_IN_DARK = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)VampiricLlamas.location("invisible_armor_in_dark"));
    public static final TagKey<Item> VAMPIRE_ARMOR = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)VampiricLlamas.location("vampire_armor"));
    public static final TagKey<Item> ACTS_AS_TOTEM_OF_UNDYING = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)VampiricLlamas.location("acts_as_totem_of_undying"));
    public static final TagKey<Enchantment> MAKES_ARMOR_INVISIBLE_IN_DARK = TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)VampiricLlamas.location("makes_armor_invisible_in_dark"));
    public static final int IS_DARK_FOR_VAMPIRE_EFFECTS = 7;
    public static final TagKey<MobEffect> FLIGHT_DISABLING_EFFECTS = TagKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)VampiricLlamas.location("flight_disabling_effects"));

    public VampiricLlamas(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        VampiricLlamasArmorMaterials.init(modEventBus);
        VampiricLlamasBlocks.init(modEventBus);
        VampiricLlamasCreativeModeTabs.init(modEventBus);
        VampiricLlamasDataComponents.init(modEventBus);
        VampiricLlamasEntities.init(modEventBus);
        VampiricLlamasItems.init(modEventBus);
        VampiricLlamasStructureProcessors.init(modEventBus);
        VampiricLlamasEffects.init(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(this::registerEntityAttributes);
        modEventBus.addListener(this::gatherData);
        NeoForge.EVENT_BUS.addListener(this::onStruckByLightning);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    public static boolean isInvisibleArmor(ItemStack stack, RegistryAccess access) {
        return stack.is(INVISIBLE_ARMOR_IN_DARK) || stack.getAllEnchantments(access.lookupOrThrow(Registries.ENCHANTMENT)).entrySet().stream().anyMatch(holderEntry -> ((Holder)holderEntry.getKey()).is(MAKES_ARMOR_INVISIBLE_IN_DARK));
    }

    public static boolean isDarkEnoughForVampireEffects(Level level, BlockPos blockPos) {
        int blockLightLevel = level.getBrightness(LightLayer.BLOCK, blockPos);
        int skyLightLevel = level.getBrightness(LightLayer.SKY, blockPos);
        int packedLight = LightTexture.pack((int)blockLightLevel, (int)skyLightLevel);
        return VampiricLlamas.isDarkEnoughForVampireEffects(level, packedLight);
    }

    public static boolean isDarkEnoughForVampireEffects(Level level, int packedLight) {
        int blockLightLevel = LightTexture.block((int)packedLight);
        int skyLightLevel = LightTexture.sky((int)packedLight);
        boolean isDay = VampiricLlamas.isDay(level);
        boolean isSkyLightDarkEnough = skyLightLevel <= 7;
        boolean isBlockLightDarkEnough = blockLightLevel <= 7;
        boolean isNoSunlight = !isDay || isSkyLightDarkEnough;
        return isNoSunlight && isBlockLightDarkEnough;
    }

    public static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static int getSkyDarken(@NotNull Level level) {
        double d0 = 1.0 - (double)(level.getRainLevel(1.0f) * 5.0f) / 16.0;
        double d1 = 1.0 - (double)(level.getThunderLevel(1.0f) * 5.0f) / 16.0;
        double d2 = 0.5 + 2.0 * Mth.clamp((double)Mth.cos((float)(level.getTimeOfDay(1.0f) * ((float)Math.PI * 2))), (double)-0.25, (double)0.25);
        return (int)((1.0 - d2 * d0 * d1) * 11.0);
    }

    public static boolean isDay(@Nullable Level level) {
        if (level == null) {
            return true;
        }
        return VampiricLlamas.getSkyDarken(level) < 4;
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        boolean run = event.includeServer();
        generator.addProvider(run, (DataProvider)new VampiricLlamasItemModelProvider(output, existingFileHelper));
        VampiricLlamasBlockTagProvider blockTagsProvider = new VampiricLlamasBlockTagProvider(output, lookupProvider, existingFileHelper);
        generator.addProvider(run, (DataProvider)blockTagsProvider);
        generator.addProvider(run, (DataProvider)new VampiricLlamasMobEffectTagProvider(output, lookupProvider, existingFileHelper));
        generator.addProvider(run, (DataProvider)new VampiricLlamasEnglishUSLanguageProvider(output));
        generator.addProvider(run, (DataProvider)new VampiricLlamasEntityTypeTagProvider(output, lookupProvider, existingFileHelper));
        generator.addProvider(run, (DataProvider)new VampiricLlamasItemTagProvider(output, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(run, (DataProvider)new VampiricLlamasRecipeProvider(output, lookupProvider));
    }

    public void onStruckByLightning(EntityStruckByLightningEvent event) {
        Llama llama;
        Level level;
        Entity e = event.getEntity();
        if (e.getType() == EntityType.LLAMA && e instanceof Llama && (level = (llama = (Llama)e).level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            VampireLlama.convertLlamaToVampire(serverLevel, llama, false);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Map water = CauldronInteraction.WATER.map();
            water.put((Item)VampiricLlamasItems.VAMPIRE_LEATHER_BOOTS.get(), CauldronInteraction.DYED_ITEM);
            water.put((Item)VampiricLlamasItems.VAMPIRE_LEATHER_LEGGINGS.get(), CauldronInteraction.DYED_ITEM);
            water.put((Item)VampiricLlamasItems.VAMPIRE_LEATHER_CHESTPLATE.get(), CauldronInteraction.DYED_ITEM);
            water.put((Item)VampiricLlamasItems.VAMPIRE_LEATHER_HELMET.get(), CauldronInteraction.DYED_ITEM);
        });
    }

    public void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)VampiricLlamasEntities.VAMPIRE_LLAMA.get(), VampireLlama.createAttributes().build());
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }
}

