/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.vampiricllamas;

import com.startraveler.vampiricllamas.VampiricLlamas;
import com.startraveler.vampiricllamas.VampiricLlamasEntities;
import com.startraveler.vampiricllamas.VampiricLlamasItems;
import com.startraveler.vampiricllamas.client.renderer.LlamaBloodSpitRenderer;
import com.startraveler.vampiricllamas.client.renderer.VampireCloakLayer;
import com.startraveler.vampiricllamas.client.renderer.VampireLlamaRenderer;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import org.jetbrains.annotations.NotNull;

@Mod(value="vampiricllamas", dist={Dist.CLIENT})
@EventBusSubscriber(modid="vampiricllamas", value={Dist.CLIENT})
public class VampiricLlamasClient {
    public static final int DEFAULT_BLACK_TINT = -13684945;

    public VampiricLlamasClient(ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    @SubscribeEvent
    static void addVampireCloakElytraLayer(EntityRenderersEvent.AddLayers event) {
        EntityRenderer entityRenderer;
        for (PlayerSkin.Model skin : event.getSkins()) {
            entityRenderer = event.getSkin(skin);
            if (!(entityRenderer instanceof PlayerRenderer)) continue;
            PlayerRenderer pr = (PlayerRenderer)entityRenderer;
            pr.addLayer(new VampireCloakLayer(pr, event.getEntityModels()));
        }
        for (EntityType entityType : event.getEntityTypes()) {
            entityRenderer = event.getRenderer(entityType);
            if (!(entityRenderer instanceof HumanoidMobRenderer)) continue;
            HumanoidMobRenderer hmr = (HumanoidMobRenderer)entityRenderer;
            hmr.addLayer(new VampireCloakLayer(hmr, event.getEntityModels()));
        }
        EntityRenderer entityRenderer2 = event.getRenderer(EntityType.ARMOR_STAND);
        if (entityRenderer2 instanceof LivingEntityRenderer) {
            LivingEntityRenderer ler = (LivingEntityRenderer)entityRenderer2;
            ler.addLayer(new VampireCloakLayer(ler, event.getEntityModels()));
        }
    }

    @SubscribeEvent
    static void addElytraLayer(EntityRenderersEvent.AddLayers event) {
        EntityRenderer entityRenderer = event.getRenderer(EntityType.PLAYER);
        if (entityRenderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)entityRenderer;
            VampiricLlamas.LOGGER.warn("\n\n\n\n\nENTITY RENDER LAYER BEING ADDED\n\n\n\n\n");
            livingEntityRenderer.addLayer(new VampireCloakLayer(livingEntityRenderer, event.getContext().getModelSet()));
        }
    }

    @SubscribeEvent
    static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            EntityRenderers.register((EntityType)((EntityType)VampiricLlamasEntities.VAMPIRE_LLAMA.get()), context -> new VampireLlamaRenderer(context, ModelLayers.LLAMA));
            EntityRenderers.register((EntityType)((EntityType)VampiricLlamasEntities.LLAMA_BLOOD_SPIT.get()), LlamaBloodSpitRenderer::new);
        });
    }

    @SubscribeEvent
    static void onRegisterClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public int getDefaultDyeColor(@NotNull ItemStack stack) {
                return stack.is(ItemTags.DYEABLE) ? FastColor.ARGB32.opaque((int)DyedItemColor.getOrDefault((ItemStack)stack, (int)-13684945)) : -1;
            }
        }, new Item[]{(Item)VampiricLlamasItems.VAMPIRE_LEATHER_HELMET.get(), (Item)VampiricLlamasItems.VAMPIRE_LEATHER_CHESTPLATE.get(), (Item)VampiricLlamasItems.VAMPIRE_CLOAK.get(), (Item)VampiricLlamasItems.VAMPIRE_LEATHER_LEGGINGS.get(), (Item)VampiricLlamasItems.VAMPIRE_LEATHER_BOOTS.get()});
    }

    @SubscribeEvent
    static void setupColorHandlers(RegisterColorHandlersEvent.Item event) {
        event.register((stack, layer) -> layer > 0 ? -1 : DyedItemColor.getOrDefault((ItemStack)stack, (int)-13684945), new ItemLike[]{VampiricLlamasItems.VAMPIRE_LEATHER_HELMET, VampiricLlamasItems.VAMPIRE_LEATHER_CHESTPLATE, VampiricLlamasItems.VAMPIRE_CLOAK, VampiricLlamasItems.VAMPIRE_LEATHER_LEGGINGS, VampiricLlamasItems.VAMPIRE_LEATHER_BOOTS});
    }
}

