/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.vampiricllamas.data;

import com.startraveler.vampiricllamas.VampiricLlamas;
import com.startraveler.vampiricllamas.VampiricLlamasEffects;
import com.startraveler.vampiricllamas.VampiricLlamasEntities;
import com.startraveler.vampiricllamas.VampiricLlamasItems;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.apache.commons.lang3.text.WordUtils;

public class VampiricLlamasEnglishUSLanguageProvider
extends LanguageProvider {
    private final Set<Block> excludedBlocks;
    private final Set<Item> excludedItems;
    private final Set<TagKey<?>> excludedTags;
    private final Set<MobEffect> excludedEffects;
    private final Set<EntityType<?>> excludedEntityTypes;

    public VampiricLlamasEnglishUSLanguageProvider(PackOutput output) {
        super(output, "vampiricllamas", "en_us");
        this.add("vampiricllamas.configuration.title", "Vampiric Llamas Configs");
        this.add("vampiricllamas.configuration.section.vampiricllamas.common.toml", "Vampiric Llamas Configs");
        this.add("vampiricllamas.configuration.section.vampiricllamas.common.toml.title", "Vampiric Llamas Configs");
        this.add("vampiricllamas.configuration.smokePuffsToCreate", "Smoke Puffs to Create");
        this.add("vampiricllamas.configuration.batsToSummon", "Bats to Summon");
        this.add("vampiricllamas.configuration.shouldOverrideDifficulty", "Override Difficulty?");
        this.add("vampiricllamas.configuration.difficultyOverride", "Overridden Difficulty");
        this.excludedBlocks = new HashSet<Block>();
        this.excludedItems = new HashSet<Item>();
        this.excludedTags = new HashSet();
        this.excludedEffects = new HashSet<MobEffect>();
        this.excludedEntityTypes = new HashSet();
    }

    protected void addTranslations() {
        this.add("creativetab.vampiric_llamas.vampiric_llamas_items", "Vampiric Llamas Items");
        this.addBlockTranslations(List.of());
        this.addTagTranslations(List.of(VampiricLlamas.INVISIBLE_ARMOR_IN_DARK, VampiricLlamas.MAKES_ARMOR_INVISIBLE_IN_DARK, VampiricLlamas.ACTS_AS_TOTEM_OF_UNDYING, VampiricLlamas.FLIGHT_DISABLING_EFFECTS));
        this.addItemTranslations(VampiricLlamasItems.ITEMS.getEntries());
        this.addEffectTranslations(VampiricLlamasEffects.MOB_EFFECTS.getEntries());
        this.addEntityTranslations(VampiricLlamasEntities.ENTITIES.getEntries());
    }

    private void exclude(EntityType<?> key, String name) {
        this.excludedEntityTypes.add(key);
        super.add(key, name);
    }

    public void exclude(Block key, String name) {
        this.excludedBlocks.add(key);
        super.add(key, name);
    }

    public void exclude(Item key, String name) {
        this.excludedItems.add(key);
        super.add(key, name);
    }

    public void exclude(MobEffect key, String name) {
        this.excludedEffects.add(key);
        super.add(key, name);
    }

    public void exclude(TagKey<?> tagKey, String name) {
        this.excludedTags.add(tagKey);
        super.add(tagKey, name);
    }

    protected void addTagTranslations(List<TagKey<?>> tags) {
        tags.forEach(tag -> {
            if (!this.excludedTags.contains(tag)) {
                this.addTag(() -> tag, WordUtils.capitalize((String)tag.location().getPath().replace('/', ' ').replace('_', ' ')));
            }
        });
    }

    protected void addBlockTranslations(Collection<? extends Holder<Block>> blocks) {
        blocks.forEach(holder -> {
            ResourceKey key;
            if (!this.excludedBlocks.contains(holder.value()) && (key = holder.getKey()) != null) {
                this.addBlock(() -> ((Holder)holder).value(), WordUtils.capitalize((String)key.location().getPath().replace('/', ' ').replace('_', ' ')));
            }
        });
    }

    protected void addEffectTranslations(Collection<? extends Holder<MobEffect>> effects) {
        effects.forEach(holder -> {
            ResourceKey key;
            if (!this.excludedEffects.contains(holder.value()) && (key = holder.getKey()) != null) {
                this.addEffect(() -> ((Holder)holder).value(), WordUtils.capitalize((String)holder.getKey().location().getPath().replace('/', ' ').replace('_', ' ')));
            }
        });
    }

    protected void addEntityTranslations(Collection<? extends Holder<EntityType<?>>> entities) {
        entities.forEach(holder -> {
            ResourceKey key;
            if (!this.excludedEntityTypes.contains(holder.value()) && (key = holder.getKey()) != null) {
                this.addEntityType(() -> ((Holder)holder).value(), WordUtils.capitalize((String)key.location().getPath().replace('/', ' ').replace('_', ' ')));
            }
        });
    }

    protected void addItemTranslations(Collection<? extends Holder<Item>> items) {
        items.forEach(holder -> {
            ResourceKey key;
            if (!this.excludedItems.contains(holder.value()) && !((Item)holder.value()).getDescriptionId().startsWith("block") && (key = holder.getKey()) != null) {
                this.addItem(() -> ((Holder)holder).value(), WordUtils.capitalize((String)key.location().getPath().replace('/', ' ').replace('_', ' ')));
            }
        });
    }
}

