/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.vampiricllamas.entity;

import com.startraveler.vampiricllamas.VampiricLlamasEntities;
import com.startraveler.vampiricllamas.entity.VampireLlama;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.projectile.LlamaSpit;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Unique;

public class LlamaBloodSpit
extends LlamaSpit {
    @Unique
    public static final Vector3f BLOOD_COLOR1 = new Vector3f(124.0f, 15.0f, 19.0f).div(255.0f);
    @Unique
    public static final Vector3f BLOOD_COLOR2 = new Vector3f(187.0f, 26.0f, 32.0f).div(255.0f);

    public LlamaBloodSpit(EntityType<? extends LlamaSpit> entityType, Level level) {
        super(entityType, level);
    }

    public LlamaBloodSpit(Level level, Llama spitter) {
        this((EntityType<? extends LlamaSpit>)((EntityType)VampiricLlamasEntities.LLAMA_BLOOD_SPIT.get()), level);
        this.setOwner((Entity)spitter);
        this.setPos(spitter.getX() - (double)(spitter.getBbWidth() + 1.0f) * 0.5 * (double)Mth.sin((float)(spitter.yBodyRot * ((float)Math.PI / 180))), spitter.getEyeY() - (double)0.1f, spitter.getZ() + (double)(spitter.getBbWidth() + 1.0f) * 0.5 * (double)Mth.cos((float)(spitter.yBodyRot * ((float)Math.PI / 180))));
    }

    protected double getDefaultGravity() {
        return 0.03;
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        LivingEntity entity;
        super.onHitEntity(result);
        Entity owner = this.getOwner();
        if (owner instanceof LivingEntity && (entity = (LivingEntity)owner).isAlive()) {
            entity.heal(this.getSpitDamage());
            VampireLlama.addParticlesAroundEntity(entity, (ParticleOptions)ParticleTypes.SMOKE, 30);
        }
    }

    public float getSpitDamage() {
        return 4.0f;
    }
}

