/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.vampiricllamas.item;

import com.startraveler.vampiricllamas.item.EffectGivingArmorItem;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class VampireCloakItem
extends EffectGivingArmorItem {
    public VampireCloakItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties, List<EffectGivingArmorItem.ArmorEffect> effects) {
        super(material, type, properties, effects);
    }

    public VampireCloakItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties, Supplier<MobEffectInstance> effect, BiPredicate<ItemStack, Entity> predicate) {
        super(material, type, properties, effect, predicate);
    }

    public boolean canElytraFly(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return ElytraItem.isFlyEnabled((ItemStack)stack);
    }

    public boolean elytraFlightTick(@NotNull ItemStack stack, LivingEntity entity, int flightTicks) {
        int nextFlightTick;
        if (!entity.level().isClientSide && (nextFlightTick = flightTicks + 1) % 10 == 0) {
            if (nextFlightTick % 20 == 0) {
                stack.hurtAndBreak(1, entity, EquipmentSlot.CHEST);
            }
            entity.gameEvent((Holder)GameEvent.ELYTRA_GLIDE);
        }
        return true;
    }

    @NotNull
    public Holder<SoundEvent> getEquipSound() {
        return SoundEvents.ARMOR_EQUIP_ELYTRA;
    }
}

