/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.vampiricllamas.data;

import com.startraveler.vampiricllamas.VampiricLlamasItems;
import java.util.LinkedHashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredItem;

public class VampiricLlamasItemModelProvider
extends ItemModelProvider {
    private static final LinkedHashMap<ResourceKey<TrimMaterial>, Float> TRIM_MATERIALS = new LinkedHashMap();

    public VampiricLlamasItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "vampiricllamas", existingFileHelper);
    }

    protected void registerModels() {
        this.spawnEggItem((Item)VampiricLlamasItems.VAMPIRE_LLAMA_SPAWN_EGG.get());
        this.spawnEggItem((Item)VampiricLlamasItems.LLAMIA_SPAWN_EGG.get());
        this.basicItem((Item)VampiricLlamasItems.VAMPIRE_LEATHER.get());
        this.basicItem((Item)VampiricLlamasItems.VAMPIRE_SCALE.get());
        this.basicItem((Item)VampiricLlamasItems.LLAMA_FANG.get());
        this.basicItem((Item)VampiricLlamasItems.TOTEM_OF_PERSISTING.get());
        this.basicItem((Item)VampiricLlamasItems.TOTEM_OF_ENVENOMATION.get());
        this.handheldItem((Item)VampiricLlamasItems.FANG_KNIFE.get());
        this.trimmedLayeredArmorItem(VampiricLlamasItems.VAMPIRE_LEATHER_HELMET);
        this.trimmedLayeredArmorItem(VampiricLlamasItems.VAMPIRE_LEATHER_CHESTPLATE);
        this.trimmedLayeredArmorItem(VampiricLlamasItems.VAMPIRE_CLOAK);
        this.trimmedLayeredArmorItem(VampiricLlamasItems.VAMPIRE_LEATHER_LEGGINGS);
        this.trimmedLayeredArmorItem(VampiricLlamasItems.VAMPIRE_LEATHER_BOOTS);
        this.trimmedArmorItem(VampiricLlamasItems.VAMPIRE_SCALE_HELMET);
        this.trimmedArmorItem(VampiricLlamasItems.VAMPIRE_SCALE_CHESTPLATE);
        this.trimmedArmorItem(VampiricLlamasItems.VAMPIRE_SCALE_LEGGINGS);
        this.trimmedArmorItem(VampiricLlamasItems.VAMPIRE_SCALE_BOOTS);
    }

    private void trimmedArmorItem(DeferredItem<ArmorItem> itemDeferredItem) {
        String MOD_ID = "vampiricllamas";
        Object object = itemDeferredItem.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            TRIM_MATERIALS.forEach((trimMaterial, value) -> {
                float trimValue = value.floatValue();
                String armorType = switch (armorItem.getEquipmentSlot()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = armorItem.toString();
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.location().getPath();
                String currentTrimName = armorItemPath + "_" + trimMaterial.location().getPath() + "_trim";
                ResourceLocation armorItemResLoc = ResourceLocation.parse((String)armorItemPath);
                ResourceLocation trimResLoc = ResourceLocation.parse((String)trimPath);
                ResourceLocation trimNameResLoc = ResourceLocation.parse((String)currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc.getNamespace() + ":item/" + armorItemResLoc.getPath())).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemDeferredItem.getId().getPath(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc.getNamespace() + ":item/" + trimNameResLoc.getPath())).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"vampiricllamas", (String)("item/" + itemDeferredItem.getId().getPath())));
            });
        }
    }

    private void trimmedLayeredArmorItem(DeferredItem<ArmorItem> itemDeferredItem) {
        String MOD_ID = "vampiricllamas";
        Object object = itemDeferredItem.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            TRIM_MATERIALS.forEach((trimMaterial, value) -> {
                float trimValue = value.floatValue();
                String armorType = switch (armorItem.getEquipmentSlot()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = armorItem.toString();
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.location().getPath();
                String currentTrimName = armorItemPath + "_" + trimMaterial.location().getPath() + "_trim";
                ResourceLocation armorItemResLoc = ResourceLocation.parse((String)armorItemPath);
                ResourceLocation trimResLoc = ResourceLocation.parse((String)trimPath);
                ResourceLocation trimNameResLoc = ResourceLocation.parse((String)currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc.getNamespace() + ":item/" + armorItemResLoc.getPath())).texture("layer1", armorItemResLoc.getNamespace() + ":item/" + armorItemResLoc.getPath() + "_overlay")).texture("layer2", trimResLoc);
                ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(itemDeferredItem.getId().getPath(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc.getNamespace() + ":item/" + trimNameResLoc.getPath())).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"vampiricllamas", (String)("item/" + itemDeferredItem.getId().getPath())))).texture("layer1", armorItemResLoc.getNamespace() + ":item/" + armorItemResLoc.getPath() + "_overlay");
            });
        }
    }

    static {
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.QUARTZ, Float.valueOf(0.1f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.IRON, Float.valueOf(0.2f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE, Float.valueOf(0.3f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.REDSTONE, Float.valueOf(0.4f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.COPPER, Float.valueOf(0.5f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.GOLD, Float.valueOf(0.6f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.EMERALD, Float.valueOf(0.7f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.DIAMOND, Float.valueOf(0.8f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.LAPIS, Float.valueOf(0.9f));
        TRIM_MATERIALS.put((ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST, Float.valueOf(1.0f));
    }
}

