/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.vampiricllamas.effect;

import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class ImmunityMobEffect
extends MobEffect {
    private final List<Pair<Integer, Holder<MobEffect>>> immuneTo;

    public ImmunityMobEffect(MobEffectCategory category, int color, List<Pair<Integer, Holder<MobEffect>>> immuneTo) {
        super(category, color);
        this.immuneTo = immuneTo;
    }

    public boolean applyEffectTick(@NotNull LivingEntity entity, int amplifier) {
        super.applyEffectTick(entity, amplifier);
        for (Pair<Integer, Holder<MobEffect>> requiredAmplifierAndEffect : this.immuneTo) {
            if ((Integer)requiredAmplifierAndEffect.left() > amplifier) continue;
            entity.removeEffect((Holder)requiredAmplifierAndEffect.right());
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

