/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.vampiricllamas.effect;

import com.startraveler.vampiricllamas.VampiricLlamasEffects;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.common.NeoForgeMod;

public class VenomMobEffect
extends MobEffect {
    public VenomMobEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        float health;
        if (!entity.hasEffect(VampiricLlamasEffects.VENOMOUS) && (health = entity.getHealth()) > 2.0f) {
            Registry damageTypes = entity.damageSources().damageTypes;
            Holder damageTypeReference = (Holder)damageTypes.getHolder(NeoForgeMod.POISON_DAMAGE).orElse(damageTypes.getHolderOrThrow(DamageTypes.MAGIC));
            if (entity.getHealth() > 3.0f) {
                entity.hurt(new DamageSource(damageTypeReference), 2.0f);
            } else {
                entity.hurt(new DamageSource(damageTypeReference), 1.0f);
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        int tickEvery = 50 >> amplifier;
        return tickEvery == 0 || duration % tickEvery == 0;
    }
}

