/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.vampiricllamas.entity;

import com.startraveler.vampiricllamas.VampiricLlamasEffects;
import com.startraveler.vampiricllamas.VampiricLlamasEntities;
import com.startraveler.vampiricllamas.entity.VampireLlama;
import com.startraveler.vampiricllamas.entity.VampiresThatAttack;
import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.TraderLlama;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class Llamia
extends Llama
implements VampiresThatAttack {
    protected static final EntityDataAccessor<Boolean> DATA_IS_ATTACKING_ID = SynchedEntityData.defineId(Llamia.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public Llamia(EntityType<? extends Llamia> entityType, Level level) {
        super(entityType, level);
    }

    public Llamia(Level level) {
        this((EntityType<? extends Llamia>)((EntityType)VampiricLlamasEntities.LLAMIA.get()), level);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Llamia.createBaseChestedHorseAttributes().add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.ATTACK_KNOCKBACK, 0.5).add(Attributes.MAX_HEALTH, 100.0).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.85f).add(Attributes.ARMOR, 10.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.SAFE_FALL_DISTANCE, 1024.0).add(Attributes.ENTITY_INTERACTION_RANGE, 10.0).add(Attributes.STEP_HEIGHT, 1.75);
    }

    public boolean doHurtTarget(@NotNull Entity entity) {
        if (!super.doHurtTarget(entity)) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).addEffect(new MobEffectInstance(VampiricLlamasEffects.VENOM, 200, 0), (Entity)this);
        }
        return true;
    }

    public void tick() {
        super.tick();
        if (this.level() instanceof ServerLevel) {
            boolean isAttacking;
            boolean bl = isAttacking = this.getTarget() != null || this.isAggressive();
            if (this.isAttacking() != isAttacking) {
                this.setAttacking(isAttacking);
            }
            if (this.tickCount % 20 == 0) {
                this.heal(2.0f);
            }
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, true));
        this.goalSelector.addGoal(4, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{VampireLlama.class, Llamia.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, VampireLlama.IS_VALID_VAMPIRE_TARGET));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Llama.class, 10, true, false, VampireLlama.IS_VALID_VAMPIRE_TARGET));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, TraderLlama.class, 10, true, false, VampireLlama.IS_VALID_VAMPIRE_TARGET));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Camel.class, 10, true, false, VampireLlama.IS_VALID_VAMPIRE_TARGET));
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_ATTACKING_ID, (Object)false);
    }

    public boolean isFood(@NotNull ItemStack stack) {
        return false;
    }

    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        SpawnGroupData result = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        this.addEffect(new MobEffectInstance(VampiricLlamasEffects.VENOMOUS, -1, 0, true, false));
        this.setPersistenceRequired();
        return result;
    }

    public boolean canMate(@NotNull Animal otherAnimal) {
        return false;
    }

    public boolean killedEntity(@NotNull ServerLevel level, @NotNull LivingEntity entity) {
        boolean result = super.killedEntity(level, entity);
        if (level.getDifficulty() == Difficulty.NORMAL || level.getDifficulty() == Difficulty.HARD) {
            TraderLlama llama;
            Llama llama2;
            if (entity instanceof Llama && (llama2 = (Llama)entity).getType() == EntityType.LLAMA && EventHooks.canLivingConvert((LivingEntity)entity, (EntityType)((EntityType)VampiricLlamasEntities.VAMPIRE_LLAMA.get()), timer -> {})) {
                if (level.getDifficulty() != Difficulty.HARD && this.random.nextBoolean()) {
                    return result;
                }
                result = VampireLlama.convertLlamaToVampire(level, llama2, result);
            } else if (entity instanceof TraderLlama && (llama = (TraderLlama)entity).getType() == EntityType.TRADER_LLAMA && EventHooks.canLivingConvert((LivingEntity)entity, (EntityType)((EntityType)VampiricLlamasEntities.LLAMIA.get()), timer -> {})) {
                if (level.getDifficulty() != Difficulty.HARD && this.random.nextBoolean()) {
                    return result;
                }
                result = VampireLlama.convertLlamaToLlamia(level, (Llama)llama, result);
            }
        }
        return result;
    }

    @Override
    public boolean isAttacking() {
        return (Boolean)this.entityData.get(DATA_IS_ATTACKING_ID);
    }

    public void setAttacking(boolean isAttacking) {
        this.entityData.set(DATA_IS_ATTACKING_ID, (Object)isAttacking);
    }
}

