/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.vampiricllamas.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.startraveler.vampiricllamas.Config;
import com.startraveler.vampiricllamas.VampiricLlamasEntities;
import com.startraveler.vampiricllamas.entity.LlamaBloodSpit;
import com.startraveler.vampiricllamas.entity.Llamia;
import com.startraveler.vampiricllamas.entity.VampiresThatAttack;
import com.startraveler.vampiricllamas.entity.goal.BoundedDistanceRangedAttackGoal;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.TraderLlama;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.common.EffectCures;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class VampireLlama
extends Llama
implements VampiresThatAttack {
    public static final int LONG_DURATION_RESURRECTION_BUFF = 240;
    public static final int SHORT_DURATION_RESURRECTION_BUFF = 60;
    public static final Predicate<LivingEntity> IS_VALID_VAMPIRE_TARGET = Predicates.and(VampireLlama::isNotUndead, VampireLlama::isNight);
    protected static final EntityDataAccessor<Integer> DATA_RESURRECTIONS_ID = SynchedEntityData.defineId(VampireLlama.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Boolean> DATA_IS_ATTACKING_ID = SynchedEntityData.defineId(VampireLlama.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final int DEFAULT_RESURRECTIONS = 1;
    private static final ItemStack CHORUS_FRUIT_STACK = new ItemStack((ItemLike)Items.CHORUS_FRUIT);

    public VampireLlama(EntityType<? extends VampireLlama> entityType, Level level) {
        super(entityType, level);
    }

    public VampireLlama(Level level) {
        this((EntityType<? extends VampireLlama>)((EntityType)VampiricLlamasEntities.VAMPIRE_LLAMA.get()), level);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return VampireLlama.createBaseChestedHorseAttributes().add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.ATTACK_KNOCKBACK, 0.5).add(Attributes.MAX_HEALTH, 50.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5).add(Attributes.ARMOR, 10.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.SAFE_FALL_DISTANCE, 1024.0).add(Attributes.ENTITY_INTERACTION_RANGE, 10.0).add(Attributes.STEP_HEIGHT, 1.75);
    }

    protected static boolean isNotUndead(LivingEntity entity) {
        return !entity.getType().is(EntityTypeTags.UNDEAD);
    }

    protected static boolean isNight(LivingEntity entity) {
        return entity.level().isNight();
    }

    protected static void addParticlesAroundEntity(LivingEntity entity, ParticleOptions particleOption, int count) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles(particleOption, entity.getX(), entity.getY() + (double)(entity.getBbHeight() / 2.0f), entity.getZ(), count, (double)(entity.getBbWidth() / 4.0f + 0.125f), (double)(entity.getBbHeight() / 4.0f + 0.125f), (double)(entity.getBbWidth() / 4.0f + 0.125f), 0.0);
        }
    }

    protected static int getBatsToSummon() {
        return Config.BATS_TO_SUMMON.getAsInt();
    }

    protected static int getSmokePuffsToCreate() {
        return Config.SMOKE_PUFFS_TO_CREATE.getAsInt();
    }

    protected static void addEffectsForDeathProtection(Entity e, int shortDuration, int longDuration) {
        if (e instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)e;
            le.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, shortDuration, 0));
            le.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, longDuration, 9));
            le.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, longDuration, 0));
            le.addEffect(new MobEffectInstance(MobEffects.CONDUIT_POWER, longDuration, 0));
        }
    }

    public static boolean convertLlamaToLlamia(@NotNull ServerLevel level, Llama llama, boolean result) {
        Llamia llamia = (Llamia)llama.convertTo((EntityType)VampiricLlamasEntities.LLAMIA.get(), true);
        if (llamia != null) {
            llamia.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(llamia.blockPosition()), MobSpawnType.CONVERSION, (SpawnGroupData)new Llama.LlamaGroupData(llama.getVariant()));
            llamia.setStrength(llama.getStrength());
            llamia.setChest(llama.hasChest());
            if (llamia.hasChest()) {
                llamia.createInventory();
            }
            Container llamaInventory = llama.getInventory();
            Container llamiaInventory = llamia.getInventory();
            int containerSize = llamaInventory.getContainerSize();
            for (int i = 0; i < containerSize; ++i) {
                llamiaInventory.setItem(i, llamaInventory.getItem(i));
            }
            EventHooks.onLivingConvert((LivingEntity)llama, (LivingEntity)llamia);
            if (!llama.isSilent()) {
                level.levelEvent(null, 1026, llama.blockPosition(), 0);
            }
            result = false;
        }
        return result;
    }

    public static boolean convertLlamaToVampire(@NotNull ServerLevel level, Llama llama, boolean result) {
        VampireLlama vampireLlama = (VampireLlama)llama.convertTo((EntityType)VampiricLlamasEntities.VAMPIRE_LLAMA.get(), true);
        if (vampireLlama != null) {
            vampireLlama.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(vampireLlama.blockPosition()), MobSpawnType.CONVERSION, (SpawnGroupData)new Llama.LlamaGroupData(llama.getVariant()));
            vampireLlama.setStrength(llama.getStrength());
            vampireLlama.setChest(llama.hasChest());
            if (vampireLlama.hasChest()) {
                vampireLlama.createInventory();
            }
            Container llamaInventory = llama.getInventory();
            Container vampireInventory = vampireLlama.getInventory();
            int containerSize = llamaInventory.getContainerSize();
            for (int i = 0; i < containerSize; ++i) {
                vampireInventory.setItem(i, llamaInventory.getItem(i));
            }
            EventHooks.onLivingConvert((LivingEntity)llama, (LivingEntity)vampireLlama);
            if (!llama.isSilent()) {
                level.levelEvent(null, 1026, llama.blockPosition(), 0);
            }
            result = false;
        }
        return result;
    }

    public void tick() {
        super.tick();
        if (this.level() instanceof ServerLevel) {
            boolean isAttacking;
            boolean bl = isAttacking = this.getTarget() != null || this.isAggressive();
            if (this.isAttacking() != isAttacking) {
                this.setAttacking(isAttacking);
            }
        }
    }

    public int getEffectiveDifficulty() {
        if (Config.SHOULD_OVERRIDE_DIFFICULTY.getAsBoolean()) {
            return Config.DIFFICULTY_OVERRIDE.getAsInt();
        }
        return this.level().getDifficulty().getId();
    }

    public boolean killedEntity(@NotNull ServerLevel level, @NotNull LivingEntity entity) {
        boolean result = super.killedEntity(level, entity);
        if (level.getDifficulty() == Difficulty.NORMAL || level.getDifficulty() == Difficulty.HARD) {
            TraderLlama llama;
            Llama llama2;
            if (entity instanceof Llama && (llama2 = (Llama)entity).getType() == EntityType.LLAMA && EventHooks.canLivingConvert((LivingEntity)entity, (EntityType)((EntityType)VampiricLlamasEntities.VAMPIRE_LLAMA.get()), timer -> {})) {
                if (level.getDifficulty() != Difficulty.HARD && this.random.nextBoolean()) {
                    return result;
                }
                result = VampireLlama.convertLlamaToVampire(level, llama2, result);
            } else if (entity instanceof TraderLlama && (llama = (TraderLlama)entity).getType() == EntityType.TRADER_LLAMA && EventHooks.canLivingConvert((LivingEntity)entity, (EntityType)((EntityType)VampiricLlamasEntities.LLAMIA.get()), timer -> {})) {
                if (level.getDifficulty() != Difficulty.HARD && this.random.nextBoolean()) {
                    return result;
                }
                result = VampireLlama.convertLlamaToLlamia(level, (Llama)llama, result);
            }
        }
        return result;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new BoundedDistanceRangedAttackGoal((RangedAttackMob)this, 1.25, 10, 20, 20.0f, FloatList.of((float)16.0f, (float)32.0f)));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, true));
        this.goalSelector.addGoal(4, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{VampireLlama.class, Llamia.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, IS_VALID_VAMPIRE_TARGET));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Llama.class, 10, true, false, IS_VALID_VAMPIRE_TARGET));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, TraderLlama.class, 10, true, false, IS_VALID_VAMPIRE_TARGET));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Camel.class, 10, true, false, IS_VALID_VAMPIRE_TARGET));
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_RESURRECTIONS_ID, (Object)1);
        builder.define(DATA_IS_ATTACKING_ID, (Object)false);
    }

    public boolean isFood(@NotNull ItemStack stack) {
        return false;
    }

    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        SpawnGroupData result = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        this.setResurrections(this.getEffectiveDifficulty());
        this.setPersistenceRequired();
        return result;
    }

    public boolean canMate(@NotNull Animal otherAnimal) {
        return false;
    }

    public void spit(LivingEntity target) {
        LlamaBloodSpit llamaSpit = new LlamaBloodSpit(this.level(), this);
        double xDifference = target.getX() - this.getX();
        double yDifference = target.getY(0.3333333333333333) - llamaSpit.getY();
        double zDifference = target.getZ() - this.getZ();
        double adjustmentForRange = Math.sqrt(xDifference * xDifference + zDifference * zDifference) * (llamaSpit.getGravity() * 10.0 / 3.0);
        llamaSpit.shoot(xDifference, yDifference + adjustmentForRange, zDifference, 2.0f, 1.0f);
        if (!this.isSilent()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.LLAMA_SPIT, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        this.level().addFreshEntity((Entity)llamaSpit);
        this.didSpit = true;
    }

    public int getResurrections() {
        return (Integer)this.entityData.get(DATA_RESURRECTIONS_ID);
    }

    public void setResurrections(int resurrectionsRemaining) {
        this.entityData.set(DATA_RESURRECTIONS_ID, (Object)resurrectionsRemaining);
    }

    @Override
    public boolean isAttacking() {
        return (Boolean)this.entityData.get(DATA_IS_ATTACKING_ID);
    }

    public void setAttacking(boolean isAttacking) {
        this.entityData.set(DATA_IS_ATTACKING_ID, (Object)isAttacking);
    }

    public boolean checkTotemDeathProtection(@NotNull DamageSource damageSource) {
        int resurrectionsRemaining = this.getResurrections();
        if (resurrectionsRemaining > 0 && !damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            this.setResurrections(--resurrectionsRemaining);
            this.setHealth(this.getMaxHealth());
            this.removeEffectsCuredBy(EffectCures.PROTECTED_BY_TOTEM);
            int difficultyScale = this.getEffectiveDifficulty();
            int shortDurationEffectLength = 60 * difficultyScale;
            int longDurationEffectLength = 240 * difficultyScale;
            this.getPassengersAndSelf().forEach(entity -> VampireLlama.addEffectsForDeathProtection(entity, shortDurationEffectLength, longDurationEffectLength));
            this.addCosmeticPhaseChangeEffects();
            if (resurrectionsRemaining == 0 && difficultyScale > 1) {
                this.makeAreaOfEffectCloud(this.getBlindnessPotion());
                Items.CHORUS_FRUIT.finishUsingItem(CHORUS_FRUIT_STACK, this.level(), (LivingEntity)this);
            } else {
                this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, shortDurationEffectLength, 1));
            }
            return true;
        }
        return super.checkTotemDeathProtection(damageSource);
    }

    private PotionContents getBlindnessPotion() {
        return new PotionContents(Optional.empty(), Optional.of(0), List.of(new MobEffectInstance(MobEffects.BLINDNESS, 100, 0)));
    }

    private void makeAreaOfEffectCloud(PotionContents potionContents) {
        AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
        areaeffectcloud.setOwner((LivingEntity)this);
        areaeffectcloud.setRadius(3.0f);
        areaeffectcloud.setRadiusOnUse(-0.5f);
        areaeffectcloud.setRadiusPerTick(-areaeffectcloud.getRadius() / (float)areaeffectcloud.getDuration());
        areaeffectcloud.setPotionContents(potionContents);
        this.level().addFreshEntity((Entity)areaeffectcloud);
    }

    private void addCosmeticPhaseChangeEffects() {
        VampireLlama.addParticlesAroundEntity((LivingEntity)this, (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, VampireLlama.getSmokePuffsToCreate());
        for (int i = 0; i < VampireLlama.getBatsToSummon(); ++i) {
            this.summonBat();
        }
    }

    protected void summonBat() {
        Bat bat = new Bat(EntityType.BAT, this.level());
        bat.setResting(false);
        bat.setPos(this.position());
        this.level().addFreshEntity((Entity)bat);
    }
}

