/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.vampiricllamas.item;

import com.startraveler.vampiricllamas.VampiricLlamas;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class EffectGivingArmorItem
extends ArmorItem {
    protected final List<ArmorEffect> effects;

    public EffectGivingArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties, Supplier<MobEffectInstance> effect, BiPredicate<ItemStack, Entity> predicate) {
        this(material, type, properties, List.of(new ArmorEffect(effect, predicate)));
    }

    public EffectGivingArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties, List<ArmorEffect> effects) {
        super(material, type, properties);
        this.effects = effects;
    }

    public static Supplier<MobEffectInstance> defaultEffect(@NotNull Holder<MobEffect> effect) {
        return EffectGivingArmorItem.defaultEffect(effect, 0);
    }

    public static Supplier<MobEffectInstance> defaultEffect(@NotNull Holder<MobEffect> effect, int amplifier) {
        return () -> new MobEffectInstance(effect, 210, amplifier, true, true);
    }

    public static BiPredicate<ItemStack, Entity> alwaysTrue() {
        return (i, e) -> true;
    }

    public static BiPredicate<ItemStack, Entity> inDarkness() {
        return (i, e) -> VampiricLlamas.isDarkEnoughForVampireEffects(e.level(), e.blockPosition());
    }

    public static BiPredicate<ItemStack, Entity> fullSuit(TagKey<Item> armors) {
        return (i, e) -> {
            Item patt0$temp = i.getItem();
            if (patt0$temp instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)patt0$temp;
                if (e instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)e;
                    int totalArmors = 0;
                    int matchingArmors = 0;
                    ResourceKey material = armorItem.getMaterial().getKey();
                    if (material != null) {
                        for (ItemStack worn : livingEntity.getArmorSlots()) {
                            ++totalArmors;
                            if (!worn.is(armors)) continue;
                            ++matchingArmors;
                        }
                    }
                    return totalArmors == matchingArmors && totalArmors > 0;
                }
            }
            return false;
        };
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!level.isClientSide()) {
                for (ItemStack wornArmor : livingEntity.getArmorSlots()) {
                    if (!wornArmor.is((Item)this)) continue;
                    for (ArmorEffect effect : this.effects) {
                        if (!effect.predicate().test(stack, entity)) continue;
                        livingEntity.addEffect(effect.effect.get());
                    }
                }
            }
        }
    }

    public record ArmorEffect(Supplier<MobEffectInstance> effect, BiPredicate<ItemStack, Entity> predicate) {
    }
}

