/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.vampiricllamas.mixin;

import com.startraveler.vampiricllamas.entity.LlamaBloodSpit;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.projectile.LlamaSpit;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(value={LlamaSpit.class})
public class LlamaSpitMixin {
    @ModifyArg(method={"onHitEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"), index=1)
    public float modifySpitDamage(float original) {
        LlamaSpit llamaSpit = (LlamaSpit)this;
        if (llamaSpit instanceof LlamaBloodSpit) {
            LlamaBloodSpit bloodSpit = (LlamaBloodSpit)llamaSpit;
            return bloodSpit.getSpitDamage();
        }
        return original;
    }

    @ModifyArg(method={"recreateFromPacket"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V"), index=0)
    public ParticleOptions modifySpitParticleType(ParticleOptions particleData) {
        LlamaSpit llamaSpit = (LlamaSpit)this;
        if (llamaSpit instanceof LlamaBloodSpit) {
            LlamaBloodSpit bloodSpit = (LlamaBloodSpit)llamaSpit;
            return new DustColorTransitionOptions(LlamaBloodSpit.BLOOD_COLOR1, LlamaBloodSpit.BLOOD_COLOR2, bloodSpit.getRandom().nextFloat() + 0.5f);
        }
        return particleData;
    }
}

