/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.cache;

import com.player2.playerengine.automaton.api.cache.IWaypoint;
import com.player2.playerengine.automaton.api.cache.IWaypointCollection;
import com.player2.playerengine.automaton.api.cache.Waypoint;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;

public class WaypointCollection
implements IWaypointCollection {
    private final Map<IWaypoint.Tag, Set<IWaypoint>> waypoints = new EnumMap(Arrays.stream(IWaypoint.Tag.values()).collect(Collectors.toMap(Function.identity(), t -> new HashSet())));

    WaypointCollection() {
    }

    public void readFromNbt(class_2487 nbt) {
        for (IWaypoint.Tag tag : IWaypoint.Tag.values()) {
            this.waypoints.put(tag, this.readFromNbt(tag, nbt.method_10554(tag.name(), 10)));
        }
    }

    private synchronized Set<IWaypoint> readFromNbt(IWaypoint.Tag tag, class_2499 nbt) {
        HashSet<IWaypoint> ret = new HashSet<IWaypoint>();
        for (int i = 0; i < nbt.size(); ++i) {
            class_2487 in = nbt.method_10602(i);
            String name = in.method_10558("name");
            long creationTimestamp = in.method_10537("created");
            BetterBlockPos pos = new BetterBlockPos(class_2512.method_10691((class_2487)in.method_10562("pos")));
            ret.add(new Waypoint(name, tag, pos, creationTimestamp));
        }
        return ret;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        for (IWaypoint.Tag waypointTag : IWaypoint.Tag.values()) {
            nbt.method_10566(waypointTag.name(), (class_2520)this.save(waypointTag));
        }
        return nbt;
    }

    private synchronized class_2499 save(IWaypoint.Tag waypointTag) {
        class_2499 list = new class_2499();
        for (IWaypoint waypoint : this.waypoints.get((Object)waypointTag)) {
            class_2487 serializedWaypoint = new class_2487();
            serializedWaypoint.method_10582("name", waypoint.getName());
            serializedWaypoint.method_10544("created", waypoint.getCreationTimestamp());
            serializedWaypoint.method_10566("pos", (class_2520)class_2512.method_10692((class_2338)waypoint.getLocation()));
            list.add((Object)serializedWaypoint);
        }
        return list;
    }

    @Override
    public void addWaypoint(IWaypoint waypoint) {
        this.waypoints.get((Object)waypoint.getTag()).add(waypoint);
    }

    @Override
    public void removeWaypoint(IWaypoint waypoint) {
        this.waypoints.get((Object)waypoint.getTag()).remove(waypoint);
    }

    @Override
    public IWaypoint getMostRecentByTag(IWaypoint.Tag tag) {
        return this.waypoints.get((Object)tag).stream().min(Comparator.comparingLong(w -> -w.getCreationTimestamp())).orElse(null);
    }

    @Override
    public Set<IWaypoint> getByTag(IWaypoint.Tag tag) {
        return Collections.unmodifiableSet(this.waypoints.get((Object)tag));
    }

    @Override
    public Set<IWaypoint> getAllWaypoints() {
        return this.waypoints.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

