/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.command.defaults;

import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.command.Command;
import com.player2.playerengine.automaton.api.command.ICommand;
import com.player2.playerengine.automaton.api.command.argument.IArgConsumer;
import com.player2.playerengine.automaton.api.command.exception.CommandException;
import com.player2.playerengine.automaton.api.command.exception.CommandNotFoundException;
import com.player2.playerengine.automaton.api.command.helpers.Paginator;
import com.player2.playerengine.automaton.api.command.helpers.TabCompleteHelper;
import com.player2.playerengine.automaton.api.command.manager.ICommandManager;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;

public class HelpCommand
extends Command {
    public HelpCommand() {
        super("help", "?");
    }

    @Override
    public void execute(class_2168 source, String label, IArgConsumer args, IBaritone baritone) throws CommandException {
        this.execute(source, label, args);
    }

    public void execute(class_2168 source, String label, IArgConsumer args) throws CommandException {
        args.requireMax(1);
        if (args.hasAny() && !args.is(Integer.class)) {
            String commandName = args.getString().toLowerCase();
            ICommand command = ICommandManager.getCommand(commandName);
            if (command == null) {
                throw new CommandNotFoundException(commandName);
            }
            this.logDirect(source, String.format("%s - %s", String.join((CharSequence)" / ", command.getNames()), command.getShortDesc()));
            this.logDirect(source, "");
            command.getLongDesc().forEach(message -> this.logDirect(source, (String)message));
            this.logDirect(source, "");
            class_5250 returnComponent = class_2561.method_43470((String)"Click to return to the help menu");
            returnComponent.method_10862(returnComponent.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, "/automatone " + label)));
            this.logDirect(source, new class_2561[]{returnComponent});
        } else {
            Paginator.paginate(args, new Paginator(source, ICommandManager.registry.descendingStream().filter(commandx -> !commandx.hiddenFromHelp()).collect(Collectors.toList())), () -> this.logDirect(source, "All Automatone commands (clickable):"), commandx -> {
                String names = String.join((CharSequence)"/", commandx.getNames());
                String name = commandx.getNames().get(0);
                class_5250 shortDescComponent = class_2561.method_43470((String)(" - " + commandx.getShortDesc()));
                shortDescComponent.method_10862(shortDescComponent.method_10866().method_27706(class_124.field_1063));
                class_5250 namesComponent = class_2561.method_43470((String)names);
                namesComponent.method_10862(namesComponent.method_10866().method_27706(class_124.field_1068));
                class_5250 hoverComponent = class_2561.method_43470((String)"");
                hoverComponent.method_10862(hoverComponent.method_10866().method_27706(class_124.field_1080));
                hoverComponent.method_10852((class_2561)namesComponent);
                hoverComponent.method_27693("\n" + commandx.getShortDesc());
                hoverComponent.method_27693("\n\nClick to view full help");
                String clickCommand = "/automatone " + String.format("%s %s", label, commandx.getNames().get(0));
                class_5250 component = class_2561.method_43470((String)name);
                component.method_10862(component.method_10866().method_27706(class_124.field_1080));
                component.method_10852((class_2561)shortDescComponent);
                component.method_10862(component.method_10866().method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)hoverComponent)).method_10958(new class_2558(class_2558.class_2559.field_11750, clickCommand)));
                return component;
            }, "/automatone " + label);
        }
    }

    @Override
    public Stream<String> tabComplete(String label, IArgConsumer args) throws CommandException {
        return args.hasExactlyOne() ? new TabCompleteHelper().addCommands().filterPrefix(args.getString()).stream() : Stream.empty();
    }

    @Override
    public String getShortDesc() {
        return "View all commands or help on specific ones";
    }

    @Override
    public List<String> getLongDesc() {
        return Arrays.asList("Using this command, you can view detailed help information on how to use certain commands of Baritone.", "", "Usage:", "> help - Lists all commands and their short descriptions.", "> help <command> - Displays help information on a specific command.");
    }
}

