/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.pathing.calc;

import com.player2.playerengine.PlayerEngine;
import com.player2.playerengine.automaton.api.Settings;
import com.player2.playerengine.automaton.api.pathing.calc.IPath;
import com.player2.playerengine.automaton.api.pathing.calc.IPathFinder;
import com.player2.playerengine.automaton.api.pathing.goals.Goal;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.PathCalculationResult;
import com.player2.playerengine.automaton.pathing.calc.Path;
import com.player2.playerengine.automaton.pathing.calc.PathNode;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.utils.NotificationHelper;
import com.player2.playerengine.automaton.utils.pathing.PathBase;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Optional;

public abstract class AbstractNodeCostSearch
implements IPathFinder {
    protected final int startX;
    protected final int startY;
    protected final int startZ;
    protected final Goal goal;
    private final CalculationContext context;
    private final Long2ObjectOpenHashMap<PathNode> map;
    protected PathNode startNode;
    protected PathNode mostRecentConsidered;
    protected final PathNode[] bestSoFar = new PathNode[COEFFICIENTS.length];
    private volatile boolean isFinished;
    protected boolean cancelRequested;
    protected static final double[] COEFFICIENTS = new double[]{1.5, 2.0, 2.5, 3.0, 4.0, 5.0, 10.0};
    protected static final double MIN_DIST_PATH = 5.0;
    protected static final double MIN_IMPROVEMENT = 0.01;

    AbstractNodeCostSearch(int startX, int startY, int startZ, Goal goal, CalculationContext context) {
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.goal = goal;
        this.context = context;
        this.map = new Long2ObjectOpenHashMap(context.baritone.settings().pathingMapDefaultSize.get().intValue(), context.baritone.settings().pathingMapLoadFactor.get().floatValue());
    }

    public void cancel() {
        this.cancelRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PathCalculationResult calculate(long primaryTimeout, long failureTimeout) {
        PathCalculationResult var8;
        if (this.isFinished) {
            throw new IllegalStateException("Path finder cannot be reused!");
        }
        this.cancelRequested = false;
        try {
            IPath path = this.calculate0(primaryTimeout, failureTimeout).map(IPath::postProcess).orElse(null);
            if (this.cancelRequested) {
                PathCalculationResult pathCalculationResult = new PathCalculationResult(PathCalculationResult.Type.CANCELLATION);
                return pathCalculationResult;
            }
            if (path == null) {
                PathCalculationResult pathCalculationResult = new PathCalculationResult(PathCalculationResult.Type.FAILURE);
                return pathCalculationResult;
            }
            int previousLength = path.length();
            Settings settings = this.context.getBaritone().settings();
            PathBase var14 = ((PathBase)path).cutoffAtLoadedChunks(this.context.bsi, settings);
            if (var14.length() < previousLength) {
                this.context.baritone.logDebug("Cutting off path at edge of loaded chunks");
                this.context.baritone.logDebug("Length decreased by " + (previousLength - var14.length()));
            } else {
                this.context.baritone.logDebug("Path ends within loaded chunks");
            }
            previousLength = var14.length();
            PathBase var15 = var14.staticCutoff(this.goal, settings);
            if (var15.length() < previousLength) {
                this.context.baritone.logDebug("Static cutoff " + previousLength + " to " + var15.length());
            }
            if (!this.goal.isInGoal(var15.getDest())) {
                PathCalculationResult pathCalculationResult = new PathCalculationResult(PathCalculationResult.Type.SUCCESS_SEGMENT, var15);
                return pathCalculationResult;
            }
            var8 = new PathCalculationResult(PathCalculationResult.Type.SUCCESS_TO_GOAL, var15);
        }
        catch (Exception var12) {
            this.context.baritone.logDirect("Pathing exception: " + String.valueOf(var12));
            PlayerEngine.LOGGER.error("Pathing exception: ", (Throwable)var12);
            PathCalculationResult pathCalculationResult = new PathCalculationResult(PathCalculationResult.Type.EXCEPTION);
            return pathCalculationResult;
        }
        finally {
            this.isFinished = true;
        }
        return var8;
    }

    protected abstract Optional<IPath> calculate0(long var1, long var3);

    protected double getDistFromStartSq(PathNode n) {
        int xDiff = n.x - this.startX;
        int yDiff = n.y - this.startY;
        int zDiff = n.z - this.startZ;
        return xDiff * xDiff + yDiff * yDiff + zDiff * zDiff;
    }

    protected PathNode getNodeAtPosition(int x, int y, int z, long hashCode) {
        PathNode node = (PathNode)this.map.get(hashCode);
        if (node == null) {
            node = new PathNode(x, y, z, this.goal);
            this.map.put(hashCode, (Object)node);
        }
        return node;
    }

    @Override
    public Optional<IPath> pathToMostRecentNodeConsidered() {
        return Optional.ofNullable(this.mostRecentConsidered).map(node -> new Path(this.startNode, (PathNode)node, 0, this.goal, this.context));
    }

    @Override
    public Optional<IPath> bestPathSoFar() {
        return this.bestSoFar(false, 0);
    }

    protected Optional<IPath> bestSoFar(boolean logInfo, int numNodes) {
        if (this.startNode == null) {
            return Optional.empty();
        }
        double bestDist = 0.0;
        for (int i = 0; i < COEFFICIENTS.length; ++i) {
            if (this.bestSoFar[i] == null) continue;
            double dist = this.getDistFromStartSq(this.bestSoFar[i]);
            if (dist > bestDist) {
                bestDist = dist;
            }
            if (!(dist > 25.0)) continue;
            if (logInfo) {
                if (COEFFICIENTS[i] >= 3.0) {
                    PlayerEngine.LOGGER.warn("Warning: cost coefficient is greater than three! Probably means that");
                    PlayerEngine.LOGGER.warn("the path I found is pretty terrible (like sneak-bridging for dozens of blocks)");
                    PlayerEngine.LOGGER.warn("But I'm going to do it anyway, because yolo");
                }
                PlayerEngine.LOGGER.info("Path goes for " + Math.sqrt(dist) + " blocks");
                this.context.baritone.logDebug("A* cost coefficient " + COEFFICIENTS[i]);
            }
            return Optional.of(new Path(this.startNode, this.bestSoFar[i], numNodes, this.goal, this.context));
        }
        if (logInfo) {
            this.context.baritone.logDebug("Even with a cost coefficient of " + COEFFICIENTS[COEFFICIENTS.length - 1] + ", I couldn't get more than " + Math.sqrt(bestDist) + " blocks");
            this.context.baritone.logDebug("No path found =(");
            if (this.context.baritone.settings().desktopNotifications.get().booleanValue()) {
                NotificationHelper.notify("No path found =(", true);
            }
        }
        return Optional.empty();
    }

    @Override
    public final boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public final Goal getGoal() {
        return this.goal;
    }

    public BetterBlockPos getStart() {
        return new BetterBlockPos(this.startX, this.startY, this.startZ);
    }

    protected int mapSize() {
        return this.map.size();
    }
}

