/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.pathing.movement.movements;

import com.google.common.collect.ImmutableSet;
import com.player2.playerengine.automaton.Baritone;
import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.pathing.movement.MovementStatus;
import com.player2.playerengine.automaton.api.utils.BetterBlockPos;
import com.player2.playerengine.automaton.api.utils.IEntityContext;
import com.player2.playerengine.automaton.api.utils.Rotation;
import com.player2.playerengine.automaton.api.utils.RotationUtils;
import com.player2.playerengine.automaton.api.utils.VecUtils;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.automaton.pathing.movement.CalculationContext;
import com.player2.playerengine.automaton.pathing.movement.Movement;
import com.player2.playerengine.automaton.pathing.movement.MovementHelper;
import com.player2.playerengine.automaton.pathing.movement.MovementState;
import com.player2.playerengine.automaton.utils.BlockStateInterface;
import com.player2.playerengine.automaton.utils.pathing.MutableMoveResult;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2399;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3736;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.jetbrains.annotations.Nullable;

public class MovementPillar
extends Movement {
    public MovementPillar(IBaritone baritone, BetterBlockPos start, BetterBlockPos end) {
        super(baritone, start, end, MovementPillar.buildPositionsToBreak((class_1297)baritone.getEntityContext().entity(), start), start);
    }

    public static BetterBlockPos[] buildPositionsToBreak(class_1297 entity, BetterBlockPos start) {
        int x = start.x;
        int y = start.y;
        int z = start.z;
        class_4048 dims = entity.method_18377(class_4050.field_18076);
        int requiredVerticalSpace = class_3532.method_15386((float)dims.field_18068);
        int requiredSideSpace = CalculationContext.getRequiredSideSpace(dims);
        int sideLength = requiredSideSpace * 2 + 1;
        BetterBlockPos[] ret = new BetterBlockPos[sideLength * sideLength];
        int i = 0;
        for (int dx = -requiredSideSpace; dx <= requiredSideSpace; ++dx) {
            for (int dz = -requiredSideSpace; dz <= requiredSideSpace; ++dz) {
                ret[i++] = new BetterBlockPos(x + dx, y + requiredVerticalSpace, z + dz);
            }
        }
        return ret;
    }

    @Override
    public double calculateCost(CalculationContext context) {
        MutableMoveResult result = new MutableMoveResult();
        MovementPillar.cost(context, this.src.x, this.src.y, this.src.z, result);
        return result.cost;
    }

    @Override
    protected Set<BetterBlockPos> calculateValidPositions() {
        return ImmutableSet.of((Object)((Object)this.src), (Object)((Object)this.dest));
    }

    public static void cost(CalculationContext context, int x, int y, int z, MutableMoveResult result) {
        class_2680 fromState = context.get(x, y, z);
        boolean climbable = MovementPillar.isClimbable(context.bsi, x, y, z);
        class_2680 fromDown = context.get(x, y - 1, z);
        if (!climbable) {
            if (fromDown.method_26164(class_3481.field_22414)) {
                return;
            }
            if (fromDown.method_26204() instanceof class_2482 && fromDown.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12681) {
                return;
            }
        } else if (context.width > 1) {
            return;
        }
        double totalHardness = 0.0;
        boolean swimmable = false;
        int requiredSideSpace = context.requiredSideSpace;
        for (int dx = -requiredSideSpace; dx <= requiredSideSpace; ++dx) {
            for (int dz = -requiredSideSpace; dz <= requiredSideSpace; ++dz) {
                double hardness;
                int checkedX = x + dx;
                int checkedY = y + context.height;
                int checkedZ = z + dz;
                class_2680 toBreak = context.get(checkedX, checkedY, checkedZ);
                class_2680 underToBreak = context.get(x, checkedY - 1, z);
                class_2248 toBreakBlock = toBreak.method_26204();
                if (toBreakBlock instanceof class_2349 || !climbable && toBreakBlock instanceof class_3736) {
                    return;
                }
                boolean water = MovementHelper.isWater(toBreak);
                if (water || MovementHelper.isWater(underToBreak)) {
                    if (MovementHelper.isFlowing(checkedX, checkedY, checkedZ, toBreak, context.bsi)) {
                        return;
                    }
                    swimmable = true;
                    if (totalHardness > 0.0) {
                        return;
                    }
                }
                if (water || !((hardness = MovementHelper.getMiningDurationTicks(context, checkedX, checkedY, checkedZ, toBreak, true)) > 0.0)) continue;
                if (hardness >= 1000000.0 || swimmable) {
                    return;
                }
                class_2680 check = context.get(checkedX, checkedY + 1, checkedZ);
                if (!(!(check.method_26204() instanceof class_2346) || toBreakBlock instanceof class_2346 && underToBreak.method_26204() instanceof class_2346)) {
                    return;
                }
                totalHardness += hardness;
            }
        }
        if (!(!swimmable && MovementHelper.isLiquid(fromState) && !context.canPlaceAgainst(x, y - 1, z, fromDown) || MovementHelper.isLiquid(fromDown) && context.assumeWalkOnWater)) {
            double placeCost = 0.0;
            if (!climbable && !swimmable) {
                placeCost = context.costOfPlacingAt(x, y, z, fromState);
                if (placeCost >= 1000000.0) {
                    return;
                }
                if (fromDown.method_26215()) {
                    placeCost += 0.1;
                }
            }
            if (!climbable && !swimmable) {
                result.cost = JUMP_ONE_BLOCK_COST + placeCost + context.jumpPenalty + totalHardness;
                result.oxygenCost = context.oxygenCost(JUMP_ONE_BLOCK_COST + placeCost + totalHardness, class_2246.field_10124.method_9564());
            } else {
                result.cost = 8.51063829787234 + totalHardness * 5.0;
                result.oxygenCost = context.oxygenCost(4.25531914893617 + totalHardness * 5.0, context.get(x, y + context.height - 1, z)) + context.oxygenCost(4.25531914893617, context.get(x, y + context.height, z));
            }
        }
    }

    private static boolean isClimbable(BlockStateInterface context, int x, int y, int z) {
        if (context.get0(x, y, z).method_26164(class_3481.field_22414)) {
            return true;
        }
        return context.get0(x, y + 1, z).method_26164(class_3481.field_22414) ? MovementHelper.isBlockNormalCube(context.get0(x, y - 1, z)) : false;
    }

    public static class_2338 getAgainst(CalculationContext context, BetterBlockPos vine) {
        if (MovementHelper.isBlockNormalCube(context.get(vine.north()))) {
            return vine.north();
        }
        if (MovementHelper.isBlockNormalCube(context.get(vine.south()))) {
            return vine.south();
        }
        if (MovementHelper.isBlockNormalCube(context.get(vine.east()))) {
            return vine.east();
        }
        return MovementHelper.isBlockNormalCube(context.get(vine.west())) ? vine.west() : null;
    }

    @Override
    public MovementState updateState(MovementState state) {
        super.updateState(state);
        if (state.getStatus() != MovementStatus.RUNNING) {
            return state;
        }
        if (this.ctx.feetPos().y < this.src.y) {
            return state.setStatus(MovementStatus.UNREACHABLE);
        }
        class_2680 fromDown = BlockStateInterface.get(this.ctx, this.src);
        if (!this.ctx.entity().method_5799() && !MovementHelper.isWater(this.ctx, this.src.up(class_3532.method_15386((float)this.ctx.entity().method_17682())))) {
            boolean blockIsThere;
            boolean ladder = MovementPillar.isClimbable(((Baritone)this.baritone).bsi, this.src.x, this.src.y, this.src.z);
            Rotation rotation = RotationUtils.calcRotationFromVec3d(this.ctx.headPos(), VecUtils.getBlockPosCenter(this.positionToPlace), new Rotation(this.ctx.entity().method_36454(), this.ctx.entity().method_36455()));
            if (!ladder) {
                state.setTarget(new MovementState.MovementTarget(new Rotation(this.ctx.entity().method_36454(), rotation.getPitch()), true));
            }
            boolean bl = blockIsThere = MovementHelper.canWalkOn(this.ctx, this.src) || ladder;
            if (ladder) {
                if (this.ctx.entity().method_17681() > 1.0f) {
                    this.baritone.logDirect("Large entities cannot climb ladders :/");
                    return state.setStatus(MovementStatus.UNREACHABLE);
                }
                class_2338 supportingBlock = MovementPillar.getSupportingBlock(this.baritone, this.ctx, this.src, fromDown);
                if (!(supportingBlock != null && this.ctx.feetPos().equals(supportingBlock.method_10084()) || this.ctx.feetPos().equals((Object)this.dest))) {
                    if (supportingBlock != null) {
                        MovementHelper.moveTowards(this.ctx, state, supportingBlock);
                    } else {
                        MovementPillar.centerForAscend(this.ctx, this.dest, state, 0.27);
                    }
                    return state.setInput(Input.JUMP, true);
                }
                return state.setStatus(MovementStatus.SUCCESS);
            }
            if (!((Baritone)this.baritone).getInventoryBehavior().selectThrowawayForLocation(true, this.src.x, this.src.y, this.src.z)) {
                return state.setStatus(MovementStatus.UNREACHABLE);
            }
            state.setInput(Input.SNEAK, this.ctx.entity().method_23318() > (double)this.dest.method_10264() || this.ctx.entity().method_23318() < (double)this.src.method_10264() + 0.2);
            double diffX = this.ctx.entity().method_23317() - ((double)this.dest.method_10263() + 0.5);
            double diffZ = this.ctx.entity().method_23321() - ((double)this.dest.method_10260() + 0.5);
            double dist = Math.sqrt(diffX * diffX + diffZ * diffZ);
            double flatMotion = Math.sqrt(this.ctx.entity().method_18798().field_1352 * this.ctx.entity().method_18798().field_1352 + this.ctx.entity().method_18798().field_1350 * this.ctx.entity().method_18798().field_1350);
            if (dist > 0.17) {
                state.setInput(Input.MOVE_FORWARD, true);
                state.setTarget(new MovementState.MovementTarget(rotation, true));
            } else if (flatMotion < 0.05) {
                state.setInput(Input.JUMP, this.ctx.entity().method_23318() < (double)this.dest.method_10264());
            }
            if (!blockIsThere) {
                class_2680 frState = BlockStateInterface.get(this.ctx, this.src);
                if (!frState.method_26215() && !frState.method_45474()) {
                    RotationUtils.reachable(this.ctx.entity(), (class_2338)this.src, this.ctx.playerController().getBlockReachDistance()).map(rot -> new MovementState.MovementTarget((Rotation)rot, true)).ifPresent(state::setTarget);
                    state.setInput(Input.JUMP, false);
                    state.setInput(Input.CLICK_LEFT, true);
                    blockIsThere = false;
                } else if (this.ctx.entity().method_5715() && (this.ctx.isLookingAt(this.src.down()) || this.ctx.isLookingAt(this.src)) && this.ctx.entity().method_23318() > (double)this.dest.method_10264() + 0.1) {
                    state.setInput(Input.CLICK_RIGHT, true);
                }
            }
            return this.ctx.feetPos().equals((Object)this.dest) && blockIsThere ? state.setStatus(MovementStatus.SUCCESS) : state;
        }
        MovementPillar.centerForAscend(this.ctx, this.dest, state, 0.2);
        state.setInput(Input.JUMP, true);
        return this.ctx.feetPos().equals((Object)this.dest) ? state.setStatus(MovementStatus.SUCCESS) : state;
    }

    @Nullable
    public static class_2338 getSupportingBlock(IBaritone baritone, IEntityContext ctx, BetterBlockPos src, class_2680 climbableBlock) {
        Object supportingBlock = class_2248.method_9501((class_265)climbableBlock.method_26220((class_1922)ctx.world(), (class_2338)src), (class_2350)class_2350.field_11036) ? null : (climbableBlock.method_26204() instanceof class_2399 ? src.offset(((class_2350)climbableBlock.method_11654((class_2769)class_2399.field_11253)).method_10153()) : MovementPillar.getAgainst(new CalculationContext(baritone), src));
        return supportingBlock;
    }

    public static void centerForAscend(IEntityContext ctx, BetterBlockPos dest, MovementState state, double allowedDistance) {
        state.setTarget(new MovementState.MovementTarget(RotationUtils.calcRotationFromVec3d(ctx.headPos(), VecUtils.getBlockPosCenter(dest), ctx.entityRotations()), false));
        class_243 destCenter = VecUtils.getBlockPosCenter(dest);
        if (Math.abs(ctx.entity().method_23317() - destCenter.field_1352) > allowedDistance || Math.abs(ctx.entity().method_23321() - destCenter.field_1350) > allowedDistance) {
            state.setInput(Input.MOVE_FORWARD, true);
        }
    }

    @Override
    protected boolean prepared(MovementState state) {
        class_2248 block;
        if ((this.ctx.feetPos().equals((Object)this.src) || this.ctx.feetPos().equals((Object)this.src.down())) && ((block = BlockStateInterface.getBlock(this.ctx, this.src.down())) == class_2246.field_9983 || block == class_2246.field_10597)) {
            state.setInput(Input.SNEAK, true);
        }
        return super.prepared(state);
    }
}

