/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.utils;

import com.player2.playerengine.automaton.api.utils.IEntityContext;
import com.player2.playerengine.automaton.utils.BlockStateInterfaceAccessWrapper;
import com.player2.playerengine.automaton.utils.accessor.ServerChunkManagerAccessor;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2826;

public class BlockStateInterface {
    private final ServerChunkManagerAccessor provider;
    protected final class_1922 world;
    public final class_2338.class_2339 isPassableBlockPos;
    public final class_1922 access;
    private class_2818 prev = null;
    private static final class_2680 AIR = class_2246.field_10124.method_9564();

    public BlockStateInterface(IEntityContext ctx) {
        this((class_1937)ctx.world());
    }

    public BlockStateInterface(class_1937 world) {
        this.world = world;
        this.provider = (ServerChunkManagerAccessor)world.method_8398();
        this.isPassableBlockPos = new class_2338.class_2339();
        this.access = new BlockStateInterfaceAccessWrapper(this);
    }

    public boolean worldContainsLoadedChunk(int blockX, int blockZ) {
        return this.provider.automatone$getChunkNow(blockX >> 4, blockZ >> 4) != null;
    }

    public static class_2248 getBlock(IEntityContext ctx, class_2338 pos) {
        return BlockStateInterface.get(ctx, pos).method_26204();
    }

    public static class_2680 get(IEntityContext ctx, class_2338 pos) {
        return ctx.world().method_8320(pos);
    }

    public class_2680 get0(class_2338 pos) {
        return this.get0(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public class_2680 get0(int x, int y, int z) {
        if (this.world.method_31601(y)) {
            return AIR;
        }
        class_2818 cached = this.prev;
        if (cached != null && cached.method_12004().field_9181 == x >> 4 && cached.method_12004().field_9180 == z >> 4) {
            return BlockStateInterface.getFromChunk(this.world, (class_2791)cached, x, y, z);
        }
        class_2818 chunk = this.provider.automatone$getChunkNow(x >> 4, z >> 4);
        if (chunk != null && !chunk.method_12223()) {
            this.prev = chunk;
            return BlockStateInterface.getFromChunk(this.world, (class_2791)chunk, x, y, z);
        }
        return AIR;
    }

    public boolean isLoaded(int x, int z) {
        class_2818 prevChunk = this.prev;
        if (prevChunk != null && prevChunk.method_12004().field_9181 == x >> 4 && prevChunk.method_12004().field_9180 == z >> 4) {
            return true;
        }
        prevChunk = this.provider.automatone$getChunkNow(x >> 4, z >> 4);
        if (prevChunk != null && !prevChunk.method_12223()) {
            this.prev = prevChunk;
            return true;
        }
        return false;
    }

    public static class_2680 getFromChunk(class_1922 world, class_2791 chunk, int x, int y, int z) {
        class_2826 section = chunk.method_12006()[world.method_31602(y)];
        return section.method_38292() ? AIR : section.method_12254(x & 0xF, y & 0xF, z & 0xF);
    }
}

