/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.utils;

import com.player2.playerengine.automaton.api.IBaritone;
import com.player2.playerengine.automaton.api.entity.IInventoryProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1831;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2248;
import net.minecraft.class_2680;

public class ToolSet {
    private final Map<class_2248, Double> breakStrengthCache = new HashMap<class_2248, Double>();
    private final Function<class_2248, Double> backendCalculation;
    private final class_1309 player;
    private final IBaritone baritone;

    public ToolSet(class_1309 player) {
        this.player = player;
        this.baritone = IBaritone.KEY.get(player);
        if (this.baritone.settings().considerPotionEffects.get().booleanValue()) {
            double amplifier = this.potionAmplifier();
            Function<Double, Double> amplify = x -> amplifier * x;
            this.backendCalculation = amplify.compose(this::getBestDestructionTime);
        } else {
            this.backendCalculation = this::getBestDestructionTime;
        }
    }

    public double getStrVsBlock(class_2680 state) {
        return this.breakStrengthCache.computeIfAbsent(state.method_26204(), this.backendCalculation);
    }

    private int getMaterialCost(class_1799 itemStack) {
        return itemStack.method_7909() instanceof class_1831 ? 1 : -1;
    }

    public boolean hasSilkTouch(class_1799 stack) {
        return class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)stack) > 0;
    }

    public int getBestSlot(class_2248 b, boolean preferSilkTouch) {
        return this.getBestSlot(b, preferSilkTouch, false);
    }

    public int getBestSlot(class_2248 b, boolean preferSilkTouch, boolean pathingCalculation) {
        if (b.method_9564().method_26204().method_36555() == 0.0f) {
            return ((IInventoryProvider)this.player).getLivingInventory().selectedSlot;
        }
        if (this.baritone.settings().disableAutoTool.get().booleanValue() && pathingCalculation) {
            return ((IInventoryProvider)this.player).getLivingInventory().selectedSlot;
        }
        int best = 0;
        double highestSpeed = Double.NEGATIVE_INFINITY;
        int lowestCost = Integer.MIN_VALUE;
        boolean bestSilkTouch = false;
        class_2680 blockState = b.method_9564();
        for (int i = 0; i < 9; ++i) {
            int cost;
            class_1799 itemStack = ((IInventoryProvider)this.player).getLivingInventory().method_5438(i);
            if (!this.baritone.settings().useSwordToMine.get().booleanValue() && itemStack.method_7909() instanceof class_1829 || this.baritone.settings().itemSaver.get().booleanValue() && itemStack.method_7919() >= itemStack.method_7936() && itemStack.method_7936() > 1) continue;
            double speed = ToolSet.calculateSpeedVsBlock(itemStack, blockState);
            boolean silkTouch = this.hasSilkTouch(itemStack);
            if (speed > highestSpeed) {
                highestSpeed = speed;
                best = i;
                lowestCost = this.getMaterialCost(itemStack);
                bestSilkTouch = silkTouch;
                continue;
            }
            if (speed != highestSpeed || ((cost = this.getMaterialCost(itemStack)) >= lowestCost || !silkTouch && bestSilkTouch) && (!preferSilkTouch || bestSilkTouch || !silkTouch)) continue;
            highestSpeed = speed;
            best = i;
            lowestCost = cost;
            bestSilkTouch = silkTouch;
        }
        return best;
    }

    private double getBestDestructionTime(class_2248 b) {
        class_1799 stack = ((IInventoryProvider)this.player).getLivingInventory().method_5438(this.getBestSlot(b, false, true));
        return ToolSet.calculateSpeedVsBlock(stack, b.method_9564()) * this.avoidanceMultiplier(b);
    }

    private double avoidanceMultiplier(class_2248 b) {
        return this.baritone.settings().blocksToAvoidBreaking.get().contains(b.method_40142().comp_349()) ? 0.1 : 1.0;
    }

    public static double calculateSpeedVsBlock(class_1799 item, class_2680 state) {
        int effLevel;
        float hardness = state.method_26214(null, null);
        if (hardness < 0.0f) {
            return -1.0;
        }
        float speed = item.method_7924(state);
        if (speed > 1.0f && (effLevel = class_1890.method_8225((class_1887)class_1893.field_9131, (class_1799)item)) > 0 && !item.method_7960()) {
            speed += (float)(effLevel * effLevel + 1);
        }
        return state.method_29291() && (item.method_7960() || !item.method_7951(state)) ? (double)(speed / 100.0f) : (double)((speed /= hardness) / 30.0f);
    }

    private double potionAmplifier() {
        class_1293 fatigueEffect;
        double speed = 1.0;
        class_1293 hasteEffect = this.player.method_6112(class_1294.field_5917);
        if (hasteEffect != null) {
            speed *= 1.0 + (double)(hasteEffect.method_5578() + 1) * 0.2;
        }
        if ((fatigueEffect = this.player.method_6112(class_1294.field_5901)) != null) {
            switch (fatigueEffect.method_5578()) {
                case 0: {
                    speed *= 0.3;
                    break;
                }
                case 1: {
                    speed *= 0.09;
                    break;
                }
                case 2: {
                    speed *= 0.0027;
                    break;
                }
                default: {
                    speed *= 8.1E-4;
                }
            }
        }
        return speed;
    }
}

