/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.automaton.utils.schematic;

import com.player2.playerengine.PlayerEngine;
import com.player2.playerengine.automaton.api.schematic.IStaticSchematic;
import com.player2.playerengine.automaton.api.schematic.MaskSchematic;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.minecraft.class_2189;
import net.minecraft.class_2680;

public class MapArtSchematic
extends MaskSchematic {
    private final int[][] heightMap;

    public MapArtSchematic(IStaticSchematic schematic) {
        super(schematic);
        this.heightMap = MapArtSchematic.generateHeightMap(schematic);
    }

    @Override
    protected boolean partOfMask(int x, int y, int z, class_2680 currentState) {
        return y >= this.heightMap[x][z];
    }

    private static int[][] generateHeightMap(IStaticSchematic schematic) {
        int[][] heightMap = new int[schematic.widthX()][schematic.lengthZ()];
        for (int x = 0; x < schematic.widthX(); ++x) {
            for (int z = 0; z < schematic.lengthZ(); ++z) {
                class_2680[] column = schematic.getColumn(x, z);
                OptionalInt lowestBlockY = MapArtSchematic.lastIndexMatching(column, state -> !(state.method_26204() instanceof class_2189));
                if (lowestBlockY.isPresent()) {
                    heightMap[x][z] = lowestBlockY.getAsInt();
                    continue;
                }
                PlayerEngine.LOGGER.warn("Column " + x + "," + z + " has no blocks, but it's apparently map art? wtf");
                PlayerEngine.LOGGER.warn("Letting it be whatever");
                heightMap[x][z] = 256;
            }
        }
        return heightMap;
    }

    private static <T> OptionalInt lastIndexMatching(T[] arr, Predicate<? super T> predicate) {
        for (int y = arr.length - 1; y >= 0; --y) {
            if (!predicate.test(arr[y])) continue;
            return OptionalInt.of(y);
        }
        return OptionalInt.empty();
    }
}

