/*
 * Decompiled with CFR 0.152.
 */
package com.player2.playerengine.chains;

import com.player2.playerengine.PlayerEngineController;
import com.player2.playerengine.PlayerEngineSettings;
import com.player2.playerengine.automaton.api.utils.input.Input;
import com.player2.playerengine.chains.SingleTaskChain;
import com.player2.playerengine.multiversion.FoodComponentWrapper;
import com.player2.playerengine.multiversion.item.ItemVer;
import com.player2.playerengine.tasks.base.TaskRunner;
import com.player2.playerengine.tasks.resources.CollectFoodTask;
import com.player2.playerengine.tasks.speedrun.DragonBreathTracker;
import com.player2.playerengine.util.ItemTarget;
import com.player2.playerengine.util.helpers.ConfigHelper;
import com.player2.playerengine.util.helpers.WorldHelper;
import java.util.Optional;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_3545;

public class FoodChain
extends SingleTaskChain {
    private static FoodChainConfig config;
    private static boolean hasFood;
    private final DragonBreathTracker dragonBreathTracker = new DragonBreathTracker();
    private boolean isTryingToEat = false;
    private boolean requestFillup = false;
    private boolean needsToCollectFood = false;
    private Optional<class_1792> cachedPerfectFood = Optional.empty();
    private boolean shouldStop = false;

    public FoodChain(TaskRunner runner) {
        super(runner);
    }

    @Override
    protected void onTaskFinish(PlayerEngineController controller) {
    }

    private void startEat(PlayerEngineController controller, class_1792 food) {
        controller.getSlotHandler().forceEquipItem(new ItemTarget(food), true);
        controller.getBaritone().getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, true);
        controller.getExtraBaritoneSettings().setInteractionPaused(true);
        this.isTryingToEat = true;
        this.requestFillup = true;
    }

    private void stopEat(PlayerEngineController controller) {
        if (this.isTryingToEat) {
            controller.getBaritone().getInputOverrideHandler().setInputForceState(Input.CLICK_RIGHT, false);
            controller.getExtraBaritoneSettings().setInteractionPaused(false);
            this.isTryingToEat = false;
            this.requestFillup = false;
            if (controller.getItemStorage().hasItem(class_1802.field_8255) && !controller.getItemStorage().hasItemInOffhand(controller, class_1802.field_8255)) {
                controller.getSlotHandler().forceEquipItemToOffhand(class_1802.field_8255);
            }
        }
    }

    public boolean isTryingToEat() {
        return this.isTryingToEat;
    }

    @Override
    public float getPriority() {
        if (this.controller == null) {
            return Float.NEGATIVE_INFINITY;
        }
        if (WorldHelper.isInNetherPortal(this.controller)) {
            this.stopEat(this.controller);
            return Float.NEGATIVE_INFINITY;
        }
        if (this.controller.getMobDefenseChain().isShielding()) {
            this.stopEat(this.controller);
            return Float.NEGATIVE_INFINITY;
        }
        this.dragonBreathTracker.updateBreath(this.controller);
        for (class_2338 playerIn : WorldHelper.getBlocksTouchingPlayer(this.controller.getEntity())) {
            if (!this.dragonBreathTracker.isTouchingDragonBreath(playerIn)) continue;
            this.stopEat(this.controller);
            return Float.NEGATIVE_INFINITY;
        }
        if (this.controller.getModSettings().isAutoEat() && !this.controller.getEntity().method_5771() && !this.shouldStop) {
            if (this.controller.getMLGBucketChain().doneMLG() && !this.controller.getMLGBucketChain().isFalling(this.controller)) {
                class_3545<Integer, Optional<class_1792>> calculation = this.calculateFood(this.controller);
                int foodScore = (Integer)calculation.method_15442();
                this.cachedPerfectFood = (Optional)calculation.method_15441();
                boolean bl = hasFood = foodScore > 0;
                if (this.requestFillup && this.controller.getBaritone().getEntityContext().hungerManager().getFoodLevel() >= 20) {
                    this.requestFillup = false;
                }
                if (!hasFood) {
                    this.requestFillup = false;
                }
                if (hasFood && (this.needsToEat() || this.requestFillup) && this.cachedPerfectFood.isPresent()) {
                    this.startEat(this.controller, this.cachedPerfectFood.get());
                } else {
                    this.stopEat(this.controller);
                }
                PlayerEngineSettings settings = this.controller.getModSettings();
                if (this.needsToCollectFood || foodScore < settings.getMinimumFoodAllowed()) {
                    boolean bl2 = this.needsToCollectFood = foodScore < settings.getFoodUnitsToCollect();
                    if (this.needsToCollectFood) {
                        this.setTask(new CollectFoodTask(settings.getFoodUnitsToCollect()));
                        return 55.0f;
                    }
                }
                this.setTask(null);
                return Float.NEGATIVE_INFINITY;
            }
            this.stopEat(this.controller);
            return Float.NEGATIVE_INFINITY;
        }
        this.stopEat(this.controller);
        return Float.NEGATIVE_INFINITY;
    }

    @Override
    public String getName() {
        return "Food chain";
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (this.controller != null) {
            this.stopEat(this.controller);
        }
    }

    public boolean needsToEat() {
        if (hasFood && !this.shouldStop) {
            class_1309 player = this.controller.getEntity();
            int foodLevel = this.controller.getBaritone().getEntityContext().hungerManager().getFoodLevel();
            float health = player.method_6032();
            if (foodLevel >= 20) {
                return false;
            }
            if (health <= 10.0f) {
                return true;
            }
            if (player.method_5809() || player.method_6059(class_1294.field_5920) || health < (float)FoodChain.config.alwaysEatWhenWitherOrFireAndHealthBelow) {
                return true;
            }
            if (foodLevel <= FoodChain.config.alwaysEatWhenBelowHunger) {
                return true;
            }
            if (health < (float)FoodChain.config.alwaysEatWhenBelowHealth) {
                return true;
            }
            if (foodLevel < FoodChain.config.alwaysEatWhenBelowHungerAndPerfectFit && this.cachedPerfectFood.isPresent()) {
                int need = 20 - foodLevel;
                class_1792 best = this.cachedPerfectFood.get();
                int fills = Optional.ofNullable(ItemVer.getFoodComponent(best)).map(FoodComponentWrapper::getHunger).orElse(-1);
                return fills > 0 && fills <= need;
            }
            return false;
        }
        return false;
    }

    private class_3545<Integer, Optional<class_1792>> calculateFood(PlayerEngineController controller) {
        class_1792 bestFood = null;
        double bestFoodScore = Double.NEGATIVE_INFINITY;
        int foodTotal = 0;
        class_1309 player = controller.getEntity();
        float health = player.method_6032();
        float hunger = controller.getBaritone().getEntityContext().hungerManager().getFoodLevel();
        float saturation = controller.getBaritone().getEntityContext().hungerManager().getSaturationLevel();
        for (class_1799 stack : controller.getItemStorage().getItemStacksPlayerInventory(true)) {
            FoodComponentWrapper food;
            if (!ItemVer.isFood(stack) || stack.method_31574(class_1802.field_8680) || (food = ItemVer.getFoodComponent(stack.method_7909())) == null) continue;
            float hungerIfEaten = Math.min(hunger + (float)food.getHunger(), 20.0f);
            float saturationIfEaten = Math.min(hungerIfEaten, saturation + food.getSaturationModifier());
            float gainedSaturation = saturationIfEaten - saturation;
            float gainedHunger = hungerIfEaten - hunger;
            float hungerWasted = (float)food.getHunger() - gainedHunger;
            float score = gainedSaturation * 2.0f - hungerWasted;
            if (stack.method_31574(class_1802.field_8511)) {
                score -= 100.0f;
            }
            if ((double)score > bestFoodScore) {
                bestFoodScore = score;
                bestFood = stack.method_7909();
            }
            foodTotal += food.getHunger() * stack.method_7947();
        }
        return new class_3545((Object)foodTotal, Optional.ofNullable(bestFood));
    }

    public boolean hasFood() {
        return hasFood;
    }

    public void shouldStop(boolean shouldStopInput) {
        this.shouldStop = shouldStopInput;
    }

    public boolean isShouldStop() {
        return this.shouldStop;
    }

    static {
        ConfigHelper.loadConfig("configs/food_chain_settings.json", FoodChainConfig::new, FoodChainConfig.class, newConfig -> {
            config = newConfig;
        });
    }

    static class FoodChainConfig {
        public int alwaysEatWhenWitherOrFireAndHealthBelow = 6;
        public int alwaysEatWhenBelowHunger = 10;
        public int alwaysEatWhenBelowHealth = 14;
        public int alwaysEatWhenBelowHungerAndPerfectFit = 15;

        FoodChainConfig() {
        }
    }
}

